package com.cku.partner.club.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.cku.oa.shop.entity.ShopGoodsClass;
import com.cku.oa.sys.entity.Org;
import com.cku.partner.club.entity.CompanionDogAppraisal;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.cku.partner.club.entity.FsbDogGrounding;
import com.cku.partner.club.service.FsbDogGroundingService;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 宠集盒上架Controller
 *
 * @author pp
 * @version 2019-07-04
 */
@Controller
@RequestMapping(value = "/partner/fsbDogGrounding")
public class FsbDogGroundingController extends BaseController {

    @Autowired
    private FsbDogGroundingService fsbDogGroundingService;

    @ModelAttribute
    public FsbDogGrounding get(@RequestParam(required = false) String id) {
        FsbDogGrounding entity = null;
        if (StringUtils.isNotBlank(id)) {
            entity = fsbDogGroundingService.get(id);
        }
        if (entity == null) {
            entity = new FsbDogGrounding();
        }
        return entity;
    }

    //	@RequiresPermissions("club:fsbDogGrounding:view")
    @RequestMapping(value = {"list", ""})
    public String list(FsbDogGrounding fsbDogGrounding, HttpServletRequest request, HttpServletResponse response, Model model) {
        Org org = (Org) UserUtils.getSession().getAttribute("org");
        fsbDogGrounding.setOrgId(org.getId());
        Page<FsbDogGrounding> page = fsbDogGroundingService.findPage(new Page<FsbDogGrounding>(request, response), fsbDogGrounding);
        model.addAttribute("page", page);
        return "partner/club/fsbDogGroundingList";
    }

    //	@RequiresPermissions("club:fsbDogGrounding:view")
    @RequestMapping(value = "form")
    public String form(FsbDogGrounding fsbDogGrounding, Model model) {
        Org org = (Org) UserUtils.getSession().getAttribute("org");
        if (StringUtils.isEmpty(fsbDogGrounding.getId())) {
            fsbDogGrounding.setMobile(org.getTel());
            fsbDogGrounding.setLinkman(org.getContact());
            fsbDogGrounding.setCity(org.getCity());
            fsbDogGrounding.setConsign("0");
        }
        if (StringUtils.isNotEmpty(fsbDogGrounding.getLifePic()) && fsbDogGrounding.getLifePic().contains(",")) {
            String[] s = fsbDogGrounding.getLifePic().split(",");
            for (int i = 0; i < s.length; i++) {
                if (i == 0)
                    fsbDogGrounding.setLifePic(s[i]);
                if (i == 1)
                    fsbDogGrounding.setLifePic5(s[i]);
                if (i == 2)
                    fsbDogGrounding.setLifePic6(s[i]);
                if (i == 3)
                    fsbDogGrounding.setLifePic7(s[i]);
                if (i == 4)
                    fsbDogGrounding.setLifePic8(s[i]);
            }
        }
        model.addAttribute("fsbDogGrounding", fsbDogGrounding);

        model.addAttribute("postalcity", UserUtils.getCity());
        return "partner/club/fsbDogGroundingForm";
    }


    //	@RequiresPermissions("club:fsbDogGrounding:edit")
    @RequestMapping(value = "save")
    public String save(FsbDogGrounding fsbDogGrounding, Model model, RedirectAttributes redirectAttributes) {
        if (!beanValidator(model, fsbDogGrounding)) {
            return form(fsbDogGrounding, model);
        }
        Org org = (Org) UserUtils.getSession().getAttribute("org");
        fsbDogGrounding.setOrgId(org.getId());
        if (StringUtils.isNotEmpty(fsbDogGrounding.getLifePic())) {
            if (StringUtils.isNotEmpty(fsbDogGrounding.getLifePic5()))
                fsbDogGrounding.setLifePic(fsbDogGrounding.getLifePic() + "," + fsbDogGrounding.getLifePic5());
            if (StringUtils.isNotEmpty(fsbDogGrounding.getLifePic6()))
                fsbDogGrounding.setLifePic(fsbDogGrounding.getLifePic() + "," + fsbDogGrounding.getLifePic6());
            if (StringUtils.isNotEmpty(fsbDogGrounding.getLifePic7()))
                fsbDogGrounding.setLifePic(fsbDogGrounding.getLifePic() + "," + fsbDogGrounding.getLifePic7());
            if (StringUtils.isNotEmpty(fsbDogGrounding.getLifePic8()))
                fsbDogGrounding.setLifePic(fsbDogGrounding.getLifePic() + "," + fsbDogGrounding.getLifePic8());
        }
        fsbDogGroundingService.save(fsbDogGrounding);
        addMessage(redirectAttributes, "保存宠集盒上架成功");
        return "redirect:/partner/fsbDogGrounding/?repage";
    }

    @RequestMapping(value = "shelf")
    public String shelf(FsbDogGrounding fsbDogGrounding, Model model, RedirectAttributes redirectAttributes) {
        FsbDogGrounding fsb = get(fsbDogGrounding.getId());
        if ("1".equals(fsbDogGrounding.getState()))
            fsb.setAddTime(new Date());
        fsb.setState(fsbDogGrounding.getState());
        fsbDogGroundingService.save(fsb);
        return "redirect:/partner/fsbDogGrounding/?repage";
    }

    //	@RequiresPermissions("club:fsbDogGrounding:edit")
    @RequestMapping(value = "delete")
    public String delete(FsbDogGrounding fsbDogGrounding, RedirectAttributes redirectAttributes) {
        fsbDogGroundingService.delete(fsbDogGrounding);
        addMessage(redirectAttributes, "删除宠集盒上架成功");
        return "redirect:/partner/fsbDogGrounding/?repage";
    }

}