/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.partner.club.entity;

import org.hibernate.validator.constraints.Length;

import java.util.Date;

import com.fasterxml.jackson.annotation.JsonFormat;

import com.thinkgem.jeesite.common.persistence.DataEntity;

/**
 * 宠集盒上架Entity
 *
 * @author pp
 * @version 2019-07-04
 */
public class FsbDogGrounding extends DataEntity<FsbDogGrounding> {

    private static final long serialVersionUID = 1L;
    private String price;        // 报价
    private String city;        // 犬只所在城市
    private String mobile;        // 电话
    private String linkman;        // 联系人
    private String lifePic;        // 生活照片
    private String lifePic5;
    private String lifePic6;
    private String lifePic7;
    private String lifePic8;
    private String state;        // 上架状态：0未上架；1已上架
    private String consign;        // 是否寄售：0：否、1：是
    private Date addTime;        // 上架时间
    private String appraisalId;        // appraisal_id

    private String petType;        // 宠物类型 0犬,1猫
    private String petName;        // 宠物姓名
    private Date petBirthdate;        // 出生日期
    private String petOwner;        // 宠物主人
    private String petOwnerMobile;        // 宠主手机号
    private String identificationFlag;        // 芯片号(身份识别码)
    private String petGender;        // 宠物性别 1公，2母
    private String petColor;        // 宠物毛色
    private String appraisalResult;        // 鉴定结果 0待鉴定，1鉴定通过，2鉴定未通过
    private String appraisal;        // 鉴定人
    private Date appraisalDate;        // 鉴定时间
    private String frontPic;		// 正面照片
    private String sidePic;		// 侧面照片
    private String backPic;		// 背面照片

    private String orgId; //机构序号

    private String operation;//1浏览2编辑

    public String getLifePic5() {
        return lifePic5;
    }

    public void setLifePic5(String lifePic5) {
        this.lifePic5 = lifePic5;
    }

    public String getLifePic6() {
        return lifePic6;
    }

    public void setLifePic6(String lifePic6) {
        this.lifePic6 = lifePic6;
    }

    public String getLifePic7() {
        return lifePic7;
    }

    public void setLifePic7(String lifePic7) {
        this.lifePic7 = lifePic7;
    }

    public String getLifePic8() {
        return lifePic8;
    }

    public void setLifePic8(String lifePic8) {
        this.lifePic8 = lifePic8;
    }

    public String getOrgId() {
        return orgId;
    }

    public void setOrgId(String orgId) {
        this.orgId = orgId;
    }

    public String getPetGender() {
        return petGender;
    }

    public void setPetGender(String petGender) {
        this.petGender = petGender;
    }

    public String getPetColor() {
        return petColor;
    }

    public void setPetColor(String petColor) {
        this.petColor = petColor;
    }

    public String getAppraisalResult() {
        return appraisalResult;
    }

    public void setAppraisalResult(String appraisalResult) {
        this.appraisalResult = appraisalResult;
    }

    public String getAppraisal() {
        return appraisal;
    }

    public void setAppraisal(String appraisal) {
        this.appraisal = appraisal;
    }

    public Date getAppraisalDate() {
        return appraisalDate;
    }

    public void setAppraisalDate(Date appraisalDate) {
        this.appraisalDate = appraisalDate;
    }

    public String getFrontPic() {
        return frontPic;
    }

    public void setFrontPic(String frontPic) {
        this.frontPic = frontPic;
    }

    public String getSidePic() {
        return sidePic;
    }

    public void setSidePic(String sidePic) {
        this.sidePic = sidePic;
    }

    public String getBackPic() {
        return backPic;
    }

    public void setBackPic(String backPic) {
        this.backPic = backPic;
    }

    public String getOperation() {
        return operation;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public String getPetType() {
        return petType;
    }

    public void setPetType(String petType) {
        this.petType = petType;
    }

    public String getPetName() {
        return petName;
    }

    public void setPetName(String petName) {
        this.petName = petName;
    }

    public Date getPetBirthdate() {
        return petBirthdate;
    }

    public void setPetBirthdate(Date petBirthdate) {
        this.petBirthdate = petBirthdate;
    }

    public String getPetOwner() {
        return petOwner;
    }

    public void setPetOwner(String petOwner) {
        this.petOwner = petOwner;
    }

    public String getPetOwnerMobile() {
        return petOwnerMobile;
    }

    public void setPetOwnerMobile(String petOwnerMobile) {
        this.petOwnerMobile = petOwnerMobile;
    }

    public String getIdentificationFlag() {
        return identificationFlag;
    }

    public void setIdentificationFlag(String identificationFlag) {
        this.identificationFlag = identificationFlag;
    }

    public FsbDogGrounding() {
        super();
    }

    public FsbDogGrounding(String id) {
        super(id);
    }

    @Length(min = 0, max = 8, message = "报价长度必须介于 0 和 8 之间")
    public String getPrice() {
        return price;
    }

    public void setPrice(String price) {
        this.price = price;
    }

    @Length(min = 0, max = 40, message = "犬只所在城市长度必须介于 0 和 40 之间")
    public String getCity() {
        return city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    @Length(min = 0, max = 20, message = "电话长度必须介于 0 和 20 之间")
    public String getMobile() {
        return mobile;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    @Length(min = 0, max = 40, message = "联系人长度必须介于 0 和 40 之间")
    public String getLinkman() {
        return linkman;
    }

    public void setLinkman(String linkman) {
        this.linkman = linkman;
    }

    @Length(min = 0, max = 180, message = "生活照片长度必须介于 0 和 180 之间")
    public String getLifePic() {
        return lifePic;
    }

    public void setLifePic(String lifePic) {
        this.lifePic = lifePic;
    }

    @Length(min = 0, max = 1, message = "上架状态：0未上架；1已上架长度必须介于 0 和 1 之间")
    public String getState() {
        return state;
    }

    public void setState(String state) {
        this.state = state;
    }

    @Length(min = 0, max = 1, message = "是否寄售：0：否、1：是长度必须介于 0 和 1 之间")
    public String getConsign() {
        return consign;
    }

    public void setConsign(String consign) {
        this.consign = consign;
    }

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    public Date getAddTime() {
        return addTime;
    }

    public void setAddTime(Date addTime) {
        this.addTime = addTime;
    }

    public String getAppraisalId() {
        return appraisalId;
    }

    public void setAppraisalId(String appraisalId) {
        this.appraisalId = appraisalId;
    }

}