/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.sys.entity;

import org.hibernate.validator.constraints.Length;

import com.thinkgem.jeesite.common.persistence.DataEntity;

/**
 * 俱乐部经营犬种Entity
 * @author yuanshuai
 * @version 2019-10-16
 */
public class OrgDogTypeLimit extends DataEntity<OrgDogTypeLimit> {
	
	private static final long serialVersionUID = 1L;
	private String orgId;		// 俱乐部id
	private String dogTypeId;		// 犬种id
	
	public OrgDogTypeLimit() {
		super();
	}

	public OrgDogTypeLimit(String id){
		super(id);
	}

	public OrgDogTypeLimit(String orgId, String dogTypeId) {
		this.orgId = orgId;
		this.dogTypeId = dogTypeId;
	}

	@Length(min=1, max=64, message="俱乐部id长度必须介于 1 和 64 之间")
	public String getOrgId() {
		return orgId;
	}

	public void setOrgId(String orgId) {
		this.orgId = orgId;
	}
	
	@Length(min=1, max=64, message="犬种id长度必须介于 1 和 64 之间")
	public String getDogTypeId() {
		return dogTypeId;
	}

	public void setDogTypeId(String dogTypeId) {
		this.dogTypeId = dogTypeId;
	}
	
}