package com.cku.oa.statistics.strategy;

import com.cku.oa.finance.cab.dao.CABFinanceStatisticsDao;
import com.cku.oa.finance.entity.PaymentOrderDetail;
import com.cku.oa.finance.entity.PaymentRecord;
import com.cku.oa.statistics.entity.SaPaymentDetail;
import com.cku.oa.statistics.service.SaPaymentDetailService;
import org.springframework.beans.factory.annotation.Autowired;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class NoProcessOneToOneStrategy implements InitSplitStrategy {

    private SaPaymentDetailService saPaymentDetailService;
    private HashMap<String,RelationShipEntity> relationShipMap;
    private HashMap<String,BigDecimal> chargingPriceMap;
    public NoProcessOneToOneStrategy( SaPaymentDetailService saPaymentDetailService,HashMap<String,RelationShipEntity> relationShipMap,HashMap<String,BigDecimal> chargingPriceMap) {
        this.saPaymentDetailService = saPaymentDetailService;
        this.relationShipMap =relationShipMap;
        this.chargingPriceMap = chargingPriceMap;
    }

    /**
     * 旧账到新张 不变平移方法且只有一个对应项 订单详细表
     */
    @Override
    public void initSplitOrderDetail(List<PaymentOrderDetail> orderDetailList ,String id) {
        RelationShipEntity relationShipEntity = relationShipMap.get(id);
        orderDetailList.forEach( r ->{
            SaPaymentDetail saDetail = new SaPaymentDetail();
            saDetail.setPaymentNum(Integer.valueOf(r.getNum()));
            saDetail.setMemberCode(r.getMemberCode());
            saDetail.setChargeDate(r.getAddTime());
            saDetail.setRunningNumber(r.getOrderCode());
            saDetail.setPaymentMoney(r.getTotalPrice());
            saDetail.setSourceCharge(id);
            if(relationShipEntity.getCab()!=null && relationShipEntity.getCab().length()>0){
                saDetail.setType(PAYMENT_TYPE_CAB);
                saDetail.setChargeItemId(relationShipEntity.getCab());
                BigDecimal price = chargingPriceMap.get(relationShipEntity.getCab());
                if(price.compareTo(new BigDecimal(0))==0){
                    saDetail.setPrice(r.getPrice());
                }else{
                    saDetail.setPrice(price.toString());
                }
            }else{
                saDetail.setType(PAYMENT_TYPE_CKU);
                saDetail.setChargeItemId(relationShipEntity.getCku());
                BigDecimal price = chargingPriceMap.get(relationShipEntity.getCku());
                if(price.compareTo(new BigDecimal(0))==0){
                    saDetail.setPrice(r.getPrice());
                }else{
                    saDetail.setPrice(price.toString());
                }
            }
            saDetail.setOrderId(r.getId());
            saDetail.setPaymentTime((r.getPaymentOrder()!=null &&r.getPaymentOrder().getPaymentTime()!=null)?r.getPaymentOrder().getPaymentTime():r.getAddTime());
            saDetail.setDeptId(relationShipEntity.getDept());
            saPaymentDetailService.save(saDetail);
        });
    }
    /**
     * 旧账到新张 不变平移方法且只有一个对应项 流水记录表
     */
    @Override
    public void initSplitRecord(List<PaymentRecord> recordList ,String id) {
        RelationShipEntity relationShipEntity = relationShipMap.get(id);
        recordList.forEach( r ->{
            SaPaymentDetail saDetail = new SaPaymentDetail();
            saDetail.setPaymentNum(r.getChargingItemNum()==null?1:Integer.valueOf(r.getChargingItemNum()));
            saDetail.setMemberCode(r.getMemberCode());
            saDetail.setChargeDate(r.getCreateDate());
            saDetail.setRunningNumber(r.getRunningNumber());
            saDetail.setPaymentMoney(r.getPaymentAmount());
            saDetail.setSourceCharge(id);

            if(relationShipEntity.getCab()!=null && relationShipEntity.getCab().length()>0){
                saDetail.setType(PAYMENT_TYPE_CAB);
                saDetail.setChargeItemId(relationShipEntity.getCab());
                BigDecimal price = chargingPriceMap.get(relationShipEntity.getCab());
                if(price.compareTo(new BigDecimal(0))==0){
                    saDetail.setPrice(r.getPrice());
                }else{
                    saDetail.setPrice(price.toString());
                }

            }else{
                saDetail.setType(PAYMENT_TYPE_CKU);
                saDetail.setChargeItemId(relationShipEntity.getCku());
                BigDecimal price = chargingPriceMap.get(relationShipEntity.getCku());
                if(price.compareTo(new BigDecimal(0))==0){
                    saDetail.setPrice(r.getPrice());
                }else{
                    saDetail.setPrice(price.toString());
                }
            }

            saDetail.setRecordId(r.getId());
            saDetail.setPaymentTime(r.getPaymentTime());
            saDetail.setDeptId(relationShipEntity.getDept());
            saPaymentDetailService.save(saDetail);
        });
    }
}
