/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.show.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.thinkgem.jeesite.common.persistence.DataEntity;
import com.thinkgem.jeesite.common.utils.excel.annotation.ExcelField;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotBlank;

import java.util.Date;

/**
 * 赛事子表Entity
 *
 * @author lgl
 * @version 2016-07-13
 */
public class ChildShows extends DataEntity<ChildShows> {

	private static final long serialVersionUID = 1L;
	private String mainShowId; // 主赛事id
	@ExcelField(title = "规则", align = 2, sort = 4)
	private String showRules; // 赛制 0 CAC 1 CACIB
	@ExcelField(title = "CAC类型(BBE相关)", align = 2, sort = 17)
	private String cacType; // 赛事CAC类型(0:CAC;1CACIB)
	@NotBlank
	@ExcelField(title = "犬展编号", align = 2, sort = 5)
	private String showCode; // 赛事编号
	@ExcelField(title = "犬展开始时间", align = 2, sort = 7)
	private Date startTime; // 开始时间
	@ExcelField(title = "犬展结束时间", align = 2, sort = 8)
	private Date endTime; // 结束时间
	@ExcelField(title = "犬展名称", align = 2, sort = 9)
	private String showName; // 赛事名称
	@ExcelField(title = "参展费", align = 2, sort = 6)
	private String fee; // 报名费
	private String discount; // 报名优惠
	private String statisticsState; // 统计状态
	// 成绩统计状态
	private String winnerState;
	private MainShows mainShows;
	private String referee; // 子赛事裁判
	private String refereeRemarks; // 子赛事裁判
	private String serialNumber; // 赛事序号
	@ExcelField(title = "是否使用优惠卷", align = 2, sort = 18)
	private String useCoupon;// 是否使用优惠卷 0可以 1不可以
	@ExcelField(title = "犬展年份", align = 2, sort = 19)
	private String year;
	private String contestJudgeType;
	private String isDiscount;		// 是否减免：0减免 1不减免

	public String getIsDiscount() {
		return isDiscount;
	}

	public void setIsDiscount(String isDiscount) {
		this.isDiscount = isDiscount;
	}

	public ChildShows() {
		super();
	}

	public ChildShows(String id) {
		super(id);
	}

	@Length(min = 0, max = 64, message = "主赛事id长度必须介于 0 和 64 之间")
	public String getMainShowId() {
		return mainShowId;
	}

	public void setMainShowId(String mainShowId) {
		this.mainShowId = mainShowId;
	}

	@Length(min = 0, max = 50, message = "赛制长度必须介于 0 和 50 之间")
	public String getShowRules() {
		return showRules;
	}

	public void setShowRules(String showRules) {
		this.showRules = showRules;
	}

	public String getCacType() {
		return cacType;
	}

	public void setCacType(String cacType) {
		this.cacType = cacType;
	}

	@Length(min = 0, max = 100, message = "赛事编号长度必须介于 0 和 100 之间")
	public String getShowCode() {
		return showCode;
	}

	public void setShowCode(String showCode) {
		this.showCode = showCode;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getStartTime() {
		return startTime;
	}

	public void setStartTime(Date startTime) {
		this.startTime = startTime;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getEndTime() {
		return endTime;
	}

	public void setEndTime(Date endTime) {
		this.endTime = endTime;
	}

	@Length(min = 0, max = 100, message = "赛事名称长度必须介于 0 和 100 之间")
	public String getShowName() {
		return showName;
	}

	public void setShowName(String showName) {
		this.showName = showName;
	}

	public String getFee() {
		return fee;
	}

	public void setFee(String fee) {
		this.fee = fee;
	}

	@Length(min = 0, max = 50, message = "报名优惠长度必须介于 0 和 50 之间")
	public String getDiscount() {
		return discount;
	}

	public void setDiscount(String discount) {
		this.discount = discount;
	}

	@Length(min = 0, max = 1, message = "统计状态长度必须介于 0 和 1 之间")
	public String getStatisticsState() {
		return statisticsState;
	}

	public void setStatisticsState(String statisticsState) {
		this.statisticsState = statisticsState;
	}

	public MainShows getMainShows() {
		return mainShows;
	}

	public void setMainShows(MainShows mainShows) {
		this.mainShows = mainShows;
	}

	public String getReferee() {
		return referee;
	}

	public void setReferee(String referee) {
		this.referee = referee;
	}

	public String getRefereeRemarks() {
		return refereeRemarks;
	}

	public void setRefereeRemarks(String refereeRemarks) {
		this.refereeRemarks = refereeRemarks;
	}

	public String getSerialNumber() {
		return serialNumber;
	}

	public void setSerialNumber(String serialNumber) {
		this.serialNumber = serialNumber;
	}

	// @ExcelField(title="主赛事id", align=2, sort=0)
	// private String tempMainShowId; // 临时主赛事id
	@ExcelField(title = "举办方式", align = 2, sort = 2)
	private String orgnizeType; // 举办方式（自办合办）
	@ExcelField(title = "主办单位", align = 2, sort = 3)
	private String organizer; // 主办单位
	@ExcelField(title = "犬展地点", align = 2, sort = 10)
	private String showLocation; // 赛事地点
	@ExcelField(title = "报名截至日期", align = 2, sort = 11)
	private Date closingTime; // 赛事地点
	@ExcelField(title = "犬展报名", align = 2, sort = 12)
	private String register; // 报名
	@ExcelField(title = "犬展报名", align = 2, sort = 13)
	private String mainShowName; // 主赛事名称
	@ExcelField(title = "参展犬只上限", align = 2, sort = 14)
	private String dogNumMax; // 犬只数上限
	@ExcelField(title = "犬展详情", align = 2, sort = 15)
	private String branchShowDetail; // 场次明细
	@ExcelField(title = "犬展详情", align = 2, sort = 16)
	private String attention; // 特别注意事项
	private String businessModelFlag;

	public String getBusinessModelFlag() {
		return businessModelFlag;
	}

	public void setBusinessModelFlag(String businessModelFlag) {
		this.businessModelFlag = businessModelFlag;
	}
	// public String getTempMainShowId() {
	// return tempMainShowId;
	// }
	//
	// public void setTempMainShowId(String tempMainShowId) {
	// this.tempMainShowId = tempMainShowId;
	// }

	public String getOrgnizeType() {
		return orgnizeType;
	}

	public void setOrgnizeType(String orgnizeType) {
		this.orgnizeType = orgnizeType;
	}

	public String getOrganizer() {
		return organizer;
	}

	public void setOrganizer(String organizer) {
		this.organizer = organizer;
	}

	public String getShowLocation() {
		return showLocation;
	}

	public void setShowLocation(String showLocation) {
		this.showLocation = showLocation;
	}

	public Date getClosingTime() {
		return closingTime;
	}

	public void setClosingTime(Date closingTime) {
		this.closingTime = closingTime;
	}

	public String getRegister() {
		return register;
	}

	public void setRegister(String register) {
		this.register = register;
	}

	public String getMainShowName() {
		return mainShowName;
	}

	public void setMainShowName(String mainShowName) {
		this.mainShowName = mainShowName;
	}

	public String getDogNumMax() {
		return dogNumMax;
	}

	public void setDogNumMax(String dogNumMax) {
		this.dogNumMax = dogNumMax;
	}

	public String getBranchShowDetail() {
		return branchShowDetail;
	}

	public void setBranchShowDetail(String branchShowDetail) {
		this.branchShowDetail = branchShowDetail;
	}

	public String getAttention() {
		return attention;
	}

	public void setAttention(String attention) {
		this.attention = attention;
	}

	public String getUseCoupon() {
		return useCoupon;
	}

	public void setUseCoupon(String useCoupon) {
		this.useCoupon = useCoupon;
	}

	public String getYear() {
		return year;
	}

	public void setYear(String year) {
		this.year = year;
	}

	public String getContestJudgeType() {
		return contestJudgeType;
	}

	public void setContestJudgeType(String contestJudgeType) {
		this.contestJudgeType = contestJudgeType;
	}

	public String getWinnerState() {
		return winnerState;
	}

	public void setWinnerState(String winnerState) {
		this.winnerState = winnerState;
	}
}