/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.shop.entity;

import org.hibernate.validator.constraints.Length;

import com.thinkgem.jeesite.common.persistence.DataEntity;

/**
 * 商城用户钱Entity
 * @author lyy
 * @version 2016-08-23
 */
public class ShopUserMoney extends DataEntity<ShopUserMoney> {
	
	private static final long serialVersionUID = 1L;
	private String memberCode;		// 会员号
	private String userMoney;		// 用户钱数
	private String community;		// 社区
	private String rebateMoney;		// 返利钱
	private String isRebate;		// 返利标签
	private String rebateTime;	//返利时间
	
	public ShopUserMoney() {
		super();
	}
	public ShopUserMoney(String memberCode,String userMoney,String rebateMoney){
		this.memberCode = memberCode;
		this.userMoney = userMoney;
		this.rebateMoney = rebateMoney;
	}
	public ShopUserMoney(String id){
		super(id);
	}

	@Length(min=0, max=64, message="会员号长度必须介于 0 和 64 之间")
	public String getMemberCode() {
		return memberCode;
	}

	public void setMemberCode(String memberCode) {
		this.memberCode = memberCode;
	}
	
	public String getUserMoney() {
		return userMoney;
	}

	public void setUserMoney(String userMoney) {
		this.userMoney = userMoney;
	}
	
	@Length(min=0, max=10, message="社区长度必须介于 0 和 10 之间")
	public String getCommunity() {
		return community;
	}

	public void setCommunity(String community) {
		this.community = community;
	}
	
	public String getRebateMoney() {
		return rebateMoney;
	}

	public void setRebateMoney(String rebateMoney) {
		this.rebateMoney = rebateMoney;
	}
	
	@Length(min=0, max=1, message="返利标签长度必须介于 0 和 1 之间")
	public String getIsRebate() {
		return isRebate;
	}

	public void setIsRebate(String isRebate) {
		this.isRebate = isRebate;
	}

	public String getRebateTime() {
		return rebateTime;
	}

	public void setRebateTime(String rebateTime) {
		this.rebateTime = rebateTime;
	}
}