/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.shop.entity;

import org.hibernate.validator.constraints.Length;

import com.thinkgem.jeesite.common.persistence.DataEntity;

/**
 * 商城用户地址Entity
 * @author lyy
 * @version 2016-08-24
 */
public class ShopUserAddress extends DataEntity<ShopUserAddress> {
	
	private static final long serialVersionUID = 1L;
	private String memberCode;		// 会员号
	private String postName;		// 收件人
	private String postDel;		// 联系电话
	private String postCode;		// 邮编
	private String province;		// 省
	private String city;		// 市
	private String address;		// 地址
	private String isDefault;		// 是否是默认地址
	
	public ShopUserAddress() {
		super();
	}

	public ShopUserAddress(String id){
		super(id);
	}

	@Length(min=0, max=64, message="会员号长度必须介于 0 和 64 之间")
	public String getMemberCode() {
		return memberCode;
	}

	public void setMemberCode(String memberCode) {
		this.memberCode = memberCode;
	}
	
	@Length(min=0, max=50, message="收件人长度必须介于 0 和 50 之间")
	public String getPostName() {
		return postName;
	}

	public void setPostName(String postName) {
		this.postName = postName;
	}
	
	@Length(min=0, max=20, message="联系电话长度必须介于 0 和 20 之间")
	public String getPostDel() {
		return postDel;
	}

	public void setPostDel(String postDel) {
		this.postDel = postDel;
	}
	
	@Length(min=0, max=10, message="邮编长度必须介于 0 和 10 之间")
	public String getPostCode() {
		return postCode;
	}

	public void setPostCode(String postCode) {
		this.postCode = postCode;
	}
	
	@Length(min=0, max=10, message="省长度必须介于 0 和 10 之间")
	public String getProvince() {
		return province;
	}

	public void setProvince(String province) {
		this.province = province;
	}
	
	@Length(min=0, max=10, message="市长度必须介于 0 和 10 之间")
	public String getCity() {
		return city;
	}

	public void setCity(String city) {
		this.city = city;
	}
	
	@Length(min=0, max=100, message="地址长度必须介于 0 和 100 之间")
	public String getAddress() {
		return address;
	}

	public void setAddress(String address) {
		this.address = address;
	}
	
	@Length(min=0, max=1, message="是否是默认地址长度必须介于 0 和 1 之间")
	public String getIsDefault() {
		return isDefault;
	}

	public void setIsDefault(String isDefault) {
		this.isDefault = isDefault;
	}
	
}