/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.project.dao;

import com.thinkgem.jeesite.common.persistence.CrudDao;
import com.thinkgem.jeesite.common.persistence.annotation.MyBatisDao;

import java.util.List;

import org.apache.ibatis.annotations.Param;

import com.cku.oa.project.entity.CkuProject;

/**
 * 技术项目表DAO接口
 * @author Sunny
 * @version 2021-12-07
 */
@MyBatisDao
public interface CkuProjectDao extends CrudDao<CkuProject> {
	
	/**
	 * 根据年份查询所有项目数据
	 */
	List<CkuProject> findListByYear(@Param("year") Integer year);
	
}