package com.cku.oa.org.dao;

import com.cku.oa.org.vo.OrgSamplingDetailListVo;
import com.cku.oa.org.vo.OrgSamplingGroupVo;
import com.thinkgem.jeesite.common.persistence.CrudDao;
import com.thinkgem.jeesite.common.persistence.annotation.MyBatisDao;
import com.cku.oa.org.entity.OrgSampling;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 俱乐部采样包发放DAO接口
 *
 * @author yuanshuai
 * @version 2023-05-28
 */
@MyBatisDao
public interface OrgSamplingDao extends CrudDao<OrgSampling> {

	/**
	 * 批量插入
	 * @author yuanshuai
	 * @date 2023/5/28 15:28
	 */
	void batchInsert(@Param("orgSamplingList") List<OrgSampling> orgSamplingList);

	/**
	 * 根据批次号分组列表
	 * @author yuanshuai
	 * @date 2023/5/28 15:56
	 */
	List<OrgSamplingGroupVo> findGroupList(OrgSamplingGroupVo groupVo);

	/**
	 * 详情列表
	 * @author yuanshuai
	 * @date 2023/5/28 17:41
	 */
	List<OrgSamplingDetailListVo> findDetailList(OrgSamplingDetailListVo listVo);

	/**
	 * 批量删除
	 * @author yuanshuai
	 * @date 2023/5/29 13:59
	 */
	void batchDelete(@Param("idList") List<String> idList);

	/**
	 * 根据批次号删除
	 * @author yuanshuai
	 * @date 2023/5/29 14:03
	 */
	void deleteByBatchNum(@Param("batchNum") String batchNum);
}