package com.cku.oa.nativedog.service;

import java.util.List;

import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import com.cku.oa.nativedog.entity.NativeDogNews;
import com.cku.oa.nativedog.dao.NativeDogNewsDao;

/**
 * 原生犬新闻Service
 * @author lyy
 * @version 2018-12-11
 */
@Service
@Transactional(readOnly = true)
public class NativeDogNewsService extends CrudService<NativeDogNewsDao, NativeDogNews> {

	public NativeDogNews get(String id) {
		return super.get(id);
	}
	
	public List<NativeDogNews> findList(NativeDogNews nativeDogNews) {
		return super.findList(nativeDogNews);
	}
	
	public Page<NativeDogNews> findPage(Page<NativeDogNews> page, NativeDogNews nativeDogNews) {
		return super.findPage(page, nativeDogNews);
	}
	
	@Transactional(readOnly = false)
	public void save(NativeDogNews nativeDogNews) {
		if (StringUtils.isNotBlank(nativeDogNews.getNewsDetail())) {
			nativeDogNews.setNewsDetail(StringEscapeUtils.unescapeHtml4(nativeDogNews.getNewsDetail()));
		}
		super.save(nativeDogNews);
	}
	
	@Transactional(readOnly = false)
	public void delete(NativeDogNews nativeDogNews) {
		super.delete(nativeDogNews);
	}
	
}