package com.cku.oa.handler.service;

import java.util.List;

import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import com.cku.oa.handler.entity.ShowHandler;
import com.cku.oa.handler.dao.ShowHandlerDao;

/**
 * 积分榜牵犬师Service
 * @author xx
 * @version 2022-06-08
 */
@Service
@Transactional(readOnly = true)
public class ShowHandlerService extends CrudService<ShowHandlerDao, ShowHandler> {

	public ShowHandler get(String id) {
		return super.get(id);
	}
	
	public List<ShowHandler> findList(ShowHandler showHandler) {
		return super.findList(showHandler);
	}
	
	public Page<ShowHandler> findPage(Page<ShowHandler> page, ShowHandler showHandler) {
		return super.findPage(page, showHandler);
	}
	
	@Transactional(readOnly = false)
	public void save(ShowHandler showHandler) {
		super.save(showHandler);
	}
	
	@Transactional(readOnly = false)
	public void delete(ShowHandler showHandler) {
		super.delete(showHandler);
	}
	
	
	public ShowHandler getByMemberCode(String memberCode) {
		return dao.getByMemberCode(memberCode);
	}
	
}