package com.cku.oa.groomerRefereeDelegate.entity;

import com.thinkgem.jeesite.common.utils.excel.annotation.ExcelField;
import org.hibernate.validator.constraints.Length;

import com.thinkgem.jeesite.common.persistence.DataEntity;

import java.util.Date;

/**
 * 美容裁判委派记录Entity
 *
 * @author 袁帅
 * @version 2021-03-16
 */
public class GroomerRefereeDelegateLog extends DataEntity<GroomerRefereeDelegateLog> {

	private static final long serialVersionUID = 1L;

	@ExcelField(title = "赛事编号", align = 2, sort = 1)
	private String mainShowId;
	@ExcelField(title = "人次", align = 2, sort = 7)
	private Integer count;
	@ExcelField(title = "裁判", align = 2, sort = 10)
	private String referees;
	@ExcelField(title = "大区", align = 2, sort = 2)
	private String region;
	@ExcelField(title = "省", align = 2, sort = 3)
	private String province;
	@ExcelField(title = "市", align = 2, sort = 4)
	private String city;
	@ExcelField(title = "开始时间", align = 2, sort = 5)
	private Date startDate;
	@ExcelField(title = "结束时间", align = 2, sort = 6)
	private Date endDate;

	public GroomerRefereeDelegateLog() {
		super();
	}

	public GroomerRefereeDelegateLog(String id) {
		super(id);
	}

	@Length(min = 1, max = 32, message = "主赛事编号长度必须介于 1 和 32 之间")
	public String getMainShowId() {
		return mainShowId;
	}

	public void setMainShowId(String mainShowId) {
		this.mainShowId = mainShowId;
	}

	public Integer getCount() {
		return count;
	}

	public void setCount(Integer count) {
		this.count = count;
	}

	public String getReferees() {
		return referees;
	}

	public void setReferees(String referees) {
		this.referees = referees;
	}

	public String getRegion() {
		return region;
	}

	public void setRegion(String region) {
		this.region = region;
	}

	public String getProvince() {
		return province;
	}

	public void setProvince(String province) {
		this.province = province;
	}

	public String getCity() {
		return city;
	}

	public void setCity(String city) {
		this.city = city;
	}

	public Date getStartDate() {
		return startDate;
	}

	public void setStartDate(Date startDate) {
		this.startDate = startDate;
	}

	public Date getEndDate() {
		return endDate;
	}

	public void setEndDate(Date endDate) {
		this.endDate = endDate;
	}
}