package com.cku.oa.groomer.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.cku.oa.groomer.entity.GroomerExamQuestions;
import com.cku.oa.groomer.service.GroomerExamQuestionsService;

/**
 * 美容考试题表Controller
 * @author hjx
 * @version 2023-11-23
 */
@Controller
@RequestMapping(value = "${adminPath}/groomer/groomerExamQuestions")
public class GroomerExamQuestionsController extends BaseController {

	@Autowired
	private GroomerExamQuestionsService groomerExamQuestionsService;
	
	@ModelAttribute
	public GroomerExamQuestions get(@RequestParam(required=false) String id) {
		GroomerExamQuestions entity = null;
		if (StringUtils.isNotBlank(id)){
			entity = groomerExamQuestionsService.get(id);
		}
		if (entity == null){
			entity = new GroomerExamQuestions();
		}
		return entity;
	}
	
	@RequiresPermissions("groomer:groomerExamQuestions:view")
	@RequestMapping(value = {"list", ""})
	public String list(GroomerExamQuestions groomerExamQuestions, HttpServletRequest request, HttpServletResponse response, Model model) {
		Page<GroomerExamQuestions> page = groomerExamQuestionsService.findPage(new Page<GroomerExamQuestions>(request, response), groomerExamQuestions); 
		model.addAttribute("page", page);
		return "oa/groomer/groomerExamQuestionsList";
	}

	@RequiresPermissions("groomer:groomerExamQuestions:view")
	@RequestMapping(value = "form")
	public String form(GroomerExamQuestions groomerExamQuestions, Model model) {
		model.addAttribute("groomerExamQuestions", groomerExamQuestions);
		return "oa/groomer/groomerExamQuestionsForm";
	}

	@RequiresPermissions("groomer:groomerExamQuestions:edit")
	@RequestMapping(value = "save")
	public String save(GroomerExamQuestions groomerExamQuestions, Model model, RedirectAttributes redirectAttributes) {
		if (!beanValidator(model, groomerExamQuestions)){
			return form(groomerExamQuestions, model);
		}
		groomerExamQuestionsService.save(groomerExamQuestions);
		addMessage(redirectAttributes, "保存美容考试题表成功");
		return "redirect:"+Global.getAdminPath()+"/groomer/groomerExamQuestions/?repage";
	}
	
	@RequiresPermissions("groomer:groomerExamQuestions:edit")
	@RequestMapping(value = "delete")
	public String delete(GroomerExamQuestions groomerExamQuestions, RedirectAttributes redirectAttributes) {
		groomerExamQuestionsService.delete(groomerExamQuestions);
		addMessage(redirectAttributes, "删除美容考试题表成功");
		return "redirect:"+Global.getAdminPath()+"/groomer/groomerExamQuestions/?repage";
	}

}