package com.cku.oa.groomer.enums;

import com.cku.oa.sys.entity.user.IEnum;

/**
 * 美容报名活动流程状态
 * @author hjx
 */
public enum GroomerQualificationStatusEnum implements IEnum<Integer> {



	REGISTERED(0, "已报名"),
	TO_BE_EXAM(1, "待考试"),

	TO_BE_RETAKEN(2, "待补考"),

	UNCLAIMED_CERTIFICATE(3, "待领取证书"),

	FINISHED(4, "已完成"),

	RESIT_EXAM_FAIL(5, "补考未通过");

	private Integer code;

	private String message;

	GroomerQualificationStatusEnum(Integer code, String message) {
		this.code = code;
		this.message = message;
	}

	@Override
	public Integer code() {
		return this.code;
	}

	@Override
	public String message() {
		return this.message;
	}

}
