/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.groomer.entity;

import java.util.Date;

import org.hibernate.validator.constraints.Length;
import org.springframework.web.multipart.MultipartFile;

import com.cku.oa.sys.entity.user.Member;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.thinkgem.jeesite.common.persistence.DataEntity;
import com.thinkgem.jeesite.common.utils.excel.annotation.ExcelField;

/**
 * 美容套餐Entity
 * 
 * @author xx
 * @version 2020-05-26
 */
public class GroomerPackage extends DataEntity<GroomerPackage> {

	private static final long serialVersionUID = 1L;
	@ExcelField(title = "赛事级别", align = 2, sort = 9)
	private String showLevel; // 赛事级别
	@ExcelField(title = "报名序号", align = 2, sort = 1)
	private String applyCode; // 报名序号
	@ExcelField(title = " 移动电话", align = 2, sort = 5)
	private String mobile; // 手机号
	@ExcelField(title = " 性别", align = 2, sort = 6)
	private String gender; // 性别
	@ExcelField(title = " 姓名", align = 2, sort = 4)
	private String name; // 姓名
	private String cardNo; // 身份证
	private String province; // 省
	private String city; // 城市
	private String area; // 区
	private String street; // 街道
	private String address; // 详细的地址
	@ExcelField(title = "比赛犬种", align = 2, sort = 8)
	private String dogBreed; // 种类
	private String avatar; // 照片
	@ExcelField(title = " 会员号", align = 2, sort = 3)
	private String memberCode; // 会员号
	@ExcelField(title = "培训学校", align = 2, sort = 7)
	private String schoolNameCn; // 培训机构
	private String orderPrice; // 单价
	private String runningNumber; // 流水号
	@ExcelField(title = "缴费", align = 2, sort = 10)
	private String paymentState; // 支付状态
	@ExcelField(title = "支付时间", align = 2, sort = 2)
	private Date paymentTime; // 支付时间

	private String paymentChargingItemId; // 收费项目

	private Date beginCreateDate; // 开始 applyTime

	private Date endCreateDate; // 结束 applyTime

	private Member member;// 会员表

	private MultipartFile avatarFile; // 照片
	@ExcelField(title = "成绩", align = 2, sort = 11)
	private String grade;

	public String getGrade() {
		return grade;
	}

	public void setGrade(String grade) {
		this.grade = grade;
	}

	public MultipartFile getAvatarFile() {
		return avatarFile;
	}

	public void setAvatarFile(MultipartFile avatarFile) {
		this.avatarFile = avatarFile;
	}

	public Date getBeginCreateDate() {
		return beginCreateDate;
	}

	public void setBeginCreateDate(Date beginCreateDate) {
		this.beginCreateDate = beginCreateDate;
	}

	public Date getEndCreateDate() {
		return endCreateDate;
	}

	public void setEndCreateDate(Date endCreateDate) {
		this.endCreateDate = endCreateDate;
	}

	public Member getMember() {
		return member;
	}

	public void setMember(Member member) {
		this.member = member;
	}

	public String getApplyCode() {
		return applyCode;
	}

	public void setApplyCode(String applyCode) {
		this.applyCode = applyCode;
	}

	public String getPaymentChargingItemId() {
		return paymentChargingItemId;
	}

	public void setPaymentChargingItemId(String paymentChargingItemId) {
		this.paymentChargingItemId = paymentChargingItemId;
	}

	public GroomerPackage() {
		super();
	}

	public GroomerPackage(String id) {
		super(id);
	}

	@Length(min = 0, max = 20, message = "赛事级别长度必须介于 0 和 20 之间")
	public String getShowLevel() {
		return showLevel;
	}

	public void setShowLevel(String showLevel) {
		this.showLevel = showLevel;
	}

	@Length(min = 0, max = 64, message = "手机号长度必须介于 0 和 64 之间")
	public String getMobile() {
		return mobile;
	}

	public void setMobile(String mobile) {
		this.mobile = mobile;
	}

	@Length(min = 0, max = 20, message = "性别长度必须介于 0 和 20 之间")
	public String getGender() {
		return gender;
	}

	public void setGender(String gender) {
		this.gender = gender;
	}

	@Length(min = 0, max = 64, message = "姓名长度必须介于 0 和 64 之间")
	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	@Length(min = 0, max = 100, message = "身份证长度必须介于 0 和 100 之间")
	public String getCardNo() {
		return cardNo;
	}

	public void setCardNo(String cardNo) {
		this.cardNo = cardNo;
	}

	@Length(min = 0, max = 50, message = "省长度必须介于 0 和 50 之间")
	public String getProvince() {
		return province;
	}

	public void setProvince(String province) {
		this.province = province;
	}

	@Length(min = 0, max = 50, message = "城市长度必须介于 0 和 50 之间")
	public String getCity() {
		return city;
	}

	public void setCity(String city) {
		this.city = city;
	}

	@Length(min = 0, max = 50, message = "区长度必须介于 0 和 50 之间")
	public String getArea() {
		return area;
	}

	public void setArea(String area) {
		this.area = area;
	}

	@Length(min = 0, max = 50, message = "街道长度必须介于 0 和 50 之间")
	public String getStreet() {
		return street;
	}

	public void setStreet(String street) {
		this.street = street;
	}

	@Length(min = 0, max = 50, message = "详细的地址长度必须介于 0 和 50 之间")
	public String getAddress() {
		return address;
	}

	public void setAddress(String address) {
		this.address = address;
	}

	@Length(min = 0, max = 50, message = "种类长度必须介于 0 和 50 之间")
	public String getDogBreed() {
		return dogBreed;
	}

	public void setDogBreed(String dogBreed) {
		this.dogBreed = dogBreed;
	}

	@Length(min = 0, max = 255, message = "照片长度必须介于 0 和 255 之间")
	public String getAvatar() {
		return avatar;
	}

	public void setAvatar(String avatar) {
		this.avatar = avatar;
	}

	@Length(min = 0, max = 64, message = "会员号长度必须介于 0 和 64 之间")
	public String getMemberCode() {
		return memberCode;
	}

	public void setMemberCode(String memberCode) {
		this.memberCode = memberCode;
	}

	@Length(min = 0, max = 100, message = "培训机构长度必须介于 0 和 100 之间")
	public String getSchoolNameCn() {
		return schoolNameCn;
	}

	public void setSchoolNameCn(String schoolNameCn) {
		this.schoolNameCn = schoolNameCn;
	}

	public String getOrderPrice() {
		return orderPrice;
	}

	public void setOrderPrice(String orderPrice) {
		this.orderPrice = orderPrice;
	}

	@Length(min = 0, max = 64, message = "流水号长度必须介于 0 和 64 之间")
	public String getRunningNumber() {
		return runningNumber;
	}

	public void setRunningNumber(String runningNumber) {
		this.runningNumber = runningNumber;
	}

	@Length(min = 0, max = 64, message = "支付状态长度必须介于 0 和 64 之间")
	public String getPaymentState() {
		return paymentState;
	}

	public void setPaymentState(String paymentState) {
		this.paymentState = paymentState;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getPaymentTime() {
		return paymentTime;
	}

	public void setPaymentTime(Date paymentTime) {
		this.paymentTime = paymentTime;
	}

}