/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.groomer.entity;

import com.cku.oa.sys.entity.user.Member;
import com.cku.oa.trainschool.entity.TrainingInstitution;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.thinkgem.jeesite.common.persistence.DataEntity;
import com.thinkgem.jeesite.common.utils.excel.annotation.ExcelField;
import org.hibernate.validator.constraints.Length;

import java.util.Date;

/**
 * 美容师结业证书Entity
 * @author cxt
 * @version 2016-07-15
 */
public class GroomerDiploma extends DataEntity<GroomerDiploma> {

	private static final long serialVersionUID = 1L;
	@ExcelField(title="id", align=2, sort=1)
	private String id;
	@ExcelField(title="姓名", align=2, sort=2)
	private String name;		// 姓名
	
	private String nameEn;
	
	@ExcelField(title="会员号", align=2, sort=9)
	private String memberCode;		// 会员号
	@ExcelField(title="开始时间", align=2, sort=3)
	private Date startDate;		// 开始时间
	@ExcelField(title="结束时间", align=2, sort=4)
	private Date endDate;		// 结束时间
	private String teacher;		// 培训教师
	@ExcelField(title="签发日期", align=2, sort=8)
	private Date issueDate;		// 签发日期
	private String schoolId; //学校id
	@ExcelField(title="结业证书号", align=2, sort=7)
	private String certificateCode;		// 证书编号
	@ExcelField(title="培训内容", align=2, sort=6)
	private String certificateLevel;		// 证书级别
	private String reviewer;		// 审核人
	private String paymentMemberCode;		// 支付人会员号
	private String printState;		// 打印状态
	private String reviewState;		// 审核状态
	private Date reviewTime;		// 审核时间
	private String reviewRemarks;		// 审核原因
	private String runningNumber;		// 流水号
	private String paymentState;		// 支付状态
	@ExcelField(title="缴费日期", align=2, sort=10)
	private Date paymentTime;		// 支付时间
	private Date proccessTime;		// 处理时间
	private String proccessState;		// 处理状态
	@ExcelField(title="培训学校名称", align=2, sort=5)
	private String schoolNameCn;           //学校名称
	private String schoolNameEn;          //学校英文
	private TrainingInstitution trainingInstitution;//美容师培训学校
	private String issDate;
	private Member member;  //会员表
	private String groomerCourseId;//课程表id
	private GroomerCourse groomerCourse;//课程表

	private Date beginDate;			//筛选条件中的起始日期
	private Date lastDate;			//筛选条件中的终止日期
	private Date beginCreateDate; // 报名 create_date
	private Date endCreateDate; // 结束 create_date


	public Date getBeginCreateDate() {
		return beginCreateDate;
	}

	public void setBeginCreateDate(Date beginCreateDate) {
		this.beginCreateDate = beginCreateDate;
	}

	public Date getEndCreateDate() {
		return endCreateDate;
	}

	public void setEndCreateDate(Date endCreateDate) {
		this.endCreateDate = endCreateDate;
	}

	public Date getBeginDate() {
		return beginDate;
	}

	public void setBeginDate(Date beginDate) {
		this.beginDate = beginDate;
	}

	public Date getLastDate() {
		return lastDate;
	}

	public void setLastDate(Date lastDate) {
		this.lastDate = lastDate;
	}

	public String getGroomerCourseId() {
		return groomerCourseId;
	}

	public void setGroomerCourseId(String groomerCourseId) {
		this.groomerCourseId = groomerCourseId;
	}

	public GroomerCourse getGroomerCourse() {
		return groomerCourse;
	}

	public void setGroomerCourse(GroomerCourse groomerCourse) {
		this.groomerCourse = groomerCourse;
	}

	public String getIssDate() {
		return issDate;
	}

	public void setIssDate(String issDate) {
		this.issDate = issDate;
	}

	public GroomerDiploma() {
		super();
	}

	public GroomerDiploma(String id){
		super(id);
	}


	public String getSchoolNameCn() {
		return schoolNameCn;
	}

	public void setSchoolNameCn(String schoolNameCn) {
		this.schoolNameCn = schoolNameCn;
	}

	public String getId() {
		return super.id;
	}

	public void setId(String id) {
		super.id = id;
	}

	@Length(min=0, max=64, message="姓名长度必须介于 0 和 64 之间")
	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	@Length(min=1, max=100, message="会员号长度必须介于 1 和 100 之间")
	public String getMemberCode() {
		return memberCode;
	}

	public void setMemberCode(String memberCode) {
		this.memberCode = memberCode;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getStartDate() {
		return startDate;
	}

	public void setStartDate(Date startDate) {
		this.startDate = startDate;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getEndDate() {
		return endDate;
	}

	public void setEndDate(Date endDate) {
		this.endDate = endDate;
	}

	@Length(min=0, max=64, message="培训教师长度必须介于 0 和 64 之间")
	public String getTeacher() {
		return teacher;
	}

	public void setTeacher(String teacher) {
		this.teacher = teacher;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getIssueDate() {
		return issueDate;
	}

	public void setIssueDate(Date issueDate) {
		this.issueDate = issueDate;
	}


	public String getNameEn() {
		return nameEn;
	}

	public void setNameEn(String nameEn) {
		this.nameEn = nameEn;
	}

	public String getSchoolId() {
		return schoolId;
	}

	public void setSchoolId(String schoolId) {
		this.schoolId = schoolId;
	}

	@Length(min=0, max=64, message="证书编号长度必须介于 0 和 64 之间")
	public String getCertificateCode() {
		return certificateCode;
	}

	public void setCertificateCode(String certificateCode) {
		this.certificateCode = certificateCode;
	}

	@Length(min=0, max=255, message="证书级别长度必须介于 0 和 255 之间")
	public String getCertificateLevel() {
		return certificateLevel;
	}

	public void setCertificateLevel(String certificateLevel) {
		this.certificateLevel = certificateLevel;
	}

	@Length(min=0, max=64, message="审核人长度必须介于 0 和 64 之间")
	public String getReviewer() {
		return reviewer;
	}

	public void setReviewer(String reviewer) {
		this.reviewer = reviewer;
	}



	@Length(min=0, max=64, message="支付人会员号长度必须介于 0 和 64 之间")
	public String getPaymentMemberCode() {
		return paymentMemberCode;
	}

	public void setPaymentMemberCode(String paymentMemberCode) {
		this.paymentMemberCode = paymentMemberCode;
	}

	@Length(min=0, max=20, message="打印状态长度必须介于 0 和 20 之间")
	public String getPrintState() {
		return printState;
	}

	public void setPrintState(String printState) {
		this.printState = printState;
	}

	@Length(min=0, max=64, message="审核状态长度必须介于 0 和 64 之间")
	public String getReviewState() {
		return reviewState;
	}

	public void setReviewState(String reviewState) {
		this.reviewState = reviewState;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getReviewTime() {
		return reviewTime;
	}

	public void setReviewTime(Date reviewTime) {
		this.reviewTime = reviewTime;
	}

	@Length(min=0, max=64, message="审核原因长度必须介于 0 和 64 之间")
	public String getReviewRemarks() {
		return reviewRemarks;
	}

	public void setReviewRemarks(String reviewRemarks) {
		this.reviewRemarks = reviewRemarks;
	}

	@Length(min=0, max=64, message="流水号长度必须介于 0 和 64 之间")
	public String getRunningNumber() {
		return runningNumber;
	}

	public void setRunningNumber(String runningNumber) {
		this.runningNumber = runningNumber;
	}

	@Length(min=0, max=64, message="支付状态长度必须介于 0 和 64 之间")
	public String getPaymentState() {
		return paymentState;
	}

	public void setPaymentState(String paymentState) {
		this.paymentState = paymentState;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getPaymentTime() {
		return paymentTime;
	}

	public void setPaymentTime(Date paymentTime) {
		this.paymentTime = paymentTime;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getProccessTime() {
		return proccessTime;
	}

	public void setProccessTime(Date proccessTime) {
		this.proccessTime = proccessTime;
	}

	@Length(min=0, max=64, message="处理状态长度必须介于 0 和 64 之间")
	public String getProccessState() {
		return proccessState;
	}

	public void setProccessState(String proccessState) {
		this.proccessState = proccessState;
	}

	public TrainingInstitution getTrainingInstitution() {
		return trainingInstitution;
	}

	public void setTrainingInstitution(TrainingInstitution trainingInstitution) {
		this.trainingInstitution = trainingInstitution;
	}

	public String getSchoolNameEn() {
		return schoolNameEn;
	}

	public void setSchoolNameEn(String schoolNameEn) {
		this.schoolNameEn = schoolNameEn;
	}

	public Member getMember() {
		return member;
	}

	public void setMember(Member member) {
		this.member = member;
	}



}