package com.cku.oa.groomer.dao;

import java.util.List;

import com.thinkgem.jeesite.common.persistence.CrudDao;
import com.thinkgem.jeesite.common.persistence.annotation.MyBatisDao;
import com.cku.oa.groomer.entity.GroomerShow;

/**
 * 美容师活动DAO接口
 * @author cxt
 * @version 2016-07-14
 */
@MyBatisDao
public interface GroomerShowDao extends CrudDao<GroomerShow> {

	/**
	 * 查询赛事类型
	 * @Author chaixueteng
	 * @2016年7月21日下午6:37:23
	 */
	public GroomerShow getShowType(String showCode);

	public GroomerShow getShowCode(String showCode);
	
	/**
	 * 活动重复校验
	 * @Author chaixueteng
	 * @2016年9月6日下午5:21:58
	 */
	public List<GroomerShow> getByShowCode(String showCode);
	
	List<GroomerShow> findEndGroomer();
	
	int updateShowStatus(List<GroomerShow> list);

}