/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.groomer.dao;

import com.cku.oa.groomer.entity.GroomerCourse;
import com.thinkgem.jeesite.common.persistence.CrudDao;
import com.thinkgem.jeesite.common.persistence.annotation.MyBatisDao;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 美容课程表DAO接口
 * @author cxt
 * @version 2017-06-19
 */
@MyBatisDao
public interface GroomerCourseDao extends CrudDao<GroomerCourse> {
	//查询近20场已经结束的课程
	List<GroomerCourse> findCourseList(GroomerCourse groomerCourse);

	String getMaxCode();

	List<GroomerCourse> getCourseList(@Param("key")String key,@Param("method")String method,@Param("type")String type,@Param("diplomaLevel")String diplomaLevel);

//按照报名多少排序
	List<GroomerCourse>  getGroomerCourseList(@Param("key")String key,@Param("type")String type,@Param("diplomaLevel")String diplomaLevel);

	List<GroomerCourse> getByIds(@Param("ids") List<String> ids);

    int autoOffCourse();

	GroomerCourse getCourseByCode(@Param("code")String code);

	void delCourseTeacher(@Param("teacherId")String teacherId);
}