package com.cku.oa.finance.service;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import com.cku.oa.finance.dao.PaymentOrderDetailDao;
import com.cku.oa.finance.dao.SaPaymentDetailTotalDao;
import com.cku.oa.finance.entity.PaymentOrderDetail;
import com.cku.oa.finance.entity.SaPaymentDetailTotal;
import com.cku.oa.finance.vo.SaPaymentWayAccountVo;
import com.cku.oa.finance.vo.SaVoucherFinishedOrderVo;
import com.cku.oa.finance.vo.SaVoucherRechargeVo;
import com.cku.oa.finance.vo.SaVoucherRefundVo;
import com.cku.oa.finance.vo.SaVoucherTransferAccountVo;
import com.cku.oa.sys.dao.user.MemberDao;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import com.thinkgem.jeesite.common.utils.Collections3;
import com.thinkgem.jeesite.common.utils.DateUtils;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.utils.excel.ExportExcel;
import com.thinkgem.jeesite.modules.sys.utils.DictUtils;

/**
 * 充值消费明细Service
 *
 * @author wangjie
 * @version 2019-08-29
 */
@Service
@Transactional(readOnly = true)
public class SaPaymentDetailTotalService extends CrudService<SaPaymentDetailTotalDao, SaPaymentDetailTotal> {

	@Autowired
	private MemberDao memberDao;

	@Autowired
	private SaPaymentDetailTotalDao saPaymentDetailTotalDao;

	@Autowired
	private PaymentOrderDetailDao paymentOrderDetailDao;

	public SaPaymentDetailTotal get(String id) {
		return super.get(id);
	}

	public List<SaPaymentDetailTotal> findList(SaPaymentDetailTotal saPaymentDetailTotal) {
		return super.findList(saPaymentDetailTotal);
	}

	public Page<SaPaymentDetailTotal> findPage(Page<SaPaymentDetailTotal> page,
			SaPaymentDetailTotal saPaymentDetailTotal) {
		return super.findPage(page, saPaymentDetailTotal);
	}

	@Transactional(readOnly = false)
	public void save(SaPaymentDetailTotal saPaymentDetailTotal) {
		super.save(saPaymentDetailTotal);
	}

	@Transactional(readOnly = false)
	public void delete(SaPaymentDetailTotal saPaymentDetailTotal) {
		super.delete(saPaymentDetailTotal);
	}

	public void export(SaPaymentDetailTotal saPaymentDetailTotal, HttpServletResponse response) throws IOException {
		List<SaPaymentDetailTotal> gqcList = dao.findList(saPaymentDetailTotal);
		if (!Collections3.isEmpty(gqcList) && gqcList.size() > 10000) {
			gqcList.subList(0, 10000);
		}
		for (SaPaymentDetailTotal data : gqcList) {
			String type = data.getType();
			if (type.equals("cab")) {
				data.setType("宠爱王国");
			} else {
				data.setType("平阳");
			}
			// 业务状态
			String businessStates = DictUtils.getDictLabel(data.getBusinessStates(), "business_states", "");
			data.setBusinessStates(businessStates);
			// 订单状态
			String orderStates = DictUtils.getDictLabel(data.getOrderStates(), "order_states", "");
			data.setOrderStates(orderStates);
			// 支付方式
			String payment_way = DictUtils.getDictLabel(data.getPaymentWay(), "payment_way", "");
			data.setPaymentWay(payment_way);
			// 账户余额
			if (StringUtils.isBlank(data.getAccountBalance())) {
				Map map = memberDao.findeOne(data.getMemberCode(),
						DateUtils.parseDate(saPaymentDetailTotal.getPaymentTimeStart()));
				if (null != map && null != map.get("before_change") && null != map.get("change_amount")) {
					BigDecimal beforeChange = new BigDecimal(map.get("before_change").toString());
					BigDecimal changeMoney = new BigDecimal(map.get("change_amount").toString());
					BigDecimal money = beforeChange.add(changeMoney);
					data.setAccountBalance(money.toString());
				} else {
					data.setAccountBalance("0.00");
				}
			}
			// 付款会员号
			if (StringUtils.isBlank(data.getCmember())) {
				if (StringUtils.isBlank(data.getOrgmember())) {
					data.setCmember(data.getMemberCode());
				} else {
					data.setCmember(data.getOrgmember());
				}
			}
		}
		new ExportExcel("", SaPaymentDetailTotal.class, 2).setDataList(gqcList).write(response, "会员充值消费明细.xlsx")
				.dispose();
	}

	/**
	 * 财务收入确认时点
	 *
	 */
	@Transactional(readOnly = false)
	public void financeConfirmTime(String businessId, String businessTable, String runningNumber) {
		// TODO zhaoxy
		PaymentOrderDetail detail = new PaymentOrderDetail();
		detail.setBusinessIds(businessId);
		detail.setBusinessTable(businessTable);
		List<PaymentOrderDetail> result = paymentOrderDetailDao.getByBusiness(detail);
		// 根据orderDetail id修改sa_payment_order_detail_total
		if (!CollectionUtils.isEmpty(result)) {
			for (PaymentOrderDetail orderDetail : result) {
				SaPaymentDetailTotal total = new SaPaymentDetailTotal();
				total.setOrderId(orderDetail.getId());
				total = saPaymentDetailTotalDao.findEntityByOrderId(total);
				saPaymentDetailTotalDao.financeConfirmNum(total);
				SaPaymentDetailTotal entity = saPaymentDetailTotalDao.findEntityByOrderId(total);
				if (entity != null) {
					// 购买次数和确认次数xiang tong
					if (entity.getPaymentNum().equals(entity.getReceiveNum())) {
						saPaymentDetailTotalDao.financeConfirmTime(total);
					}
				}
			}
			if ("dog_chip".equals(result.get(0).getBusinessTable())) {
				// dog_blood_save 登记服务费(纯种犬DNA样本) 和血统证书其他一块确认
				PaymentOrderDetail bloodSave = new PaymentOrderDetail();
				bloodSave.setBusinessCode(result.get(0).getBusinessCode());
				bloodSave.setBusinessTable("dog_blood_save");
				List<PaymentOrderDetail> bloodList = paymentOrderDetailDao.getByBusinessCode(bloodSave);
				for (PaymentOrderDetail orderDetail : bloodList) {
					SaPaymentDetailTotal total = new SaPaymentDetailTotal();
					total.setOrderId(orderDetail.getId());
					saPaymentDetailTotalDao.financeConfirmNum(total);
					SaPaymentDetailTotal entity = saPaymentDetailTotalDao.findEntityByOrderId(total);
					if (entity != null) {
						// 购买次数和确认次数xiang tong
						if (entity.getPaymentNum().equals(entity.getReceiveNum())) {
							saPaymentDetailTotalDao.financeConfirmTime(total);
						}
					}
				}
			}
		} else {
			// 根据runningNumber修改
			SaPaymentDetailTotal total = new SaPaymentDetailTotal();
			total.setRunningNumber(runningNumber);
			saPaymentDetailTotalDao.financeConfirmTime(total);
		}
	}

	/**
	 * 财务收入确认时点
	 *
	 */
	@Transactional(readOnly = false)
	public void financeConfirmTime(String businessId, String businessTable) {
		// TODO zhaoxy
		PaymentOrderDetail detail = new PaymentOrderDetail();
		detail.setBusinessIds(businessId);
		detail.setBusinessTable(businessTable);
		List<PaymentOrderDetail> result = paymentOrderDetailDao.getByBusiness(detail);
		// 根据orderDetail id修改sa_payment_order_detail_total
		if (!CollectionUtils.isEmpty(result)) {
			for (PaymentOrderDetail orderDetail : result) {
				SaPaymentDetailTotal total = new SaPaymentDetailTotal();
				total.setOrderId(orderDetail.getId());
				total = saPaymentDetailTotalDao.findEntityByOrderId(total);
				saPaymentDetailTotalDao.financeConfirmNum(total);
				SaPaymentDetailTotal entity = saPaymentDetailTotalDao.findEntityByOrderId(total);
				if (entity != null) {
					// 购买次数和确认次数xiang tong
					if (entity.getPaymentNum().equals(entity.getReceiveNum())) {
						saPaymentDetailTotalDao.financeConfirmTime(total);
					}
				}
			}
		}
	}

	/**
	 * 获取所有支付方式对应的科目
	 *
	 */
	@Transactional(readOnly = false)
	public List<SaPaymentWayAccountVo> findAllPaymentWayAccounts() {
		return saPaymentDetailTotalDao.findAllPaymentWayAccounts();
	}

	/**
	 * 获取会员账户充值凭证数据
	 *
	 */
	@Transactional(readOnly = false)
	public List<SaVoucherRechargeVo> findRechargeVoucherData(String startDate, String endDate) {
		return saPaymentDetailTotalDao.findRechargeVoucherData(startDate, endDate);
	}

	/**
	 * 获取退款凭证数据
	 *
	 */
	@Transactional(readOnly = false)
	public List<SaVoucherRefundVo> findRefundOrderVoucherData(String startDate, String endDate) {
		return saPaymentDetailTotalDao.findRefundOrderVoucherData(startDate, endDate);
	}

	/**
	 * 获取已完成订单凭证数据
	 *
	 */
	@Transactional(readOnly = false)
	public List<SaVoucherFinishedOrderVo> findFinishedOrderVoucherData(String startDate, String endDate) {
		return saPaymentDetailTotalDao.findFinishedOrderVoucherData(startDate, endDate);
	}

	/**
	 * 获取会员转账凭证数据
	 *
	 */
	@Transactional(readOnly = false)
	public List<SaVoucherTransferAccountVo> findTransferVoucherData(String startDate, String endDate) {
		return saPaymentDetailTotalDao.findTransferVoucherData(startDate, endDate);
	}

	@Transactional(readOnly = false)
	public void financeConfirmTimeNum(String runningNumber) {
		// SaPaymentDetailTotal total = new SaPaymentDetailTotal();
		// total.setRunningNumber(runningNumber);
		// saPaymentDetailTotalDao.financeConfirmNum(total);
		//
		// SaPaymentDetailTotal entity =
		// saPaymentDetailTotalDao.findEntityByOrderId(total);
		// if(entity != null) {
		// // 购买次数和确认次数xiang tong
		// if(entity.getPaymentNum().equals(entity.getReceiveNum())) {
		// saPaymentDetailTotalDao.financeConfirmTime(total);
		// }
		// }
	}

	@Transactional(readOnly = false)
	public int financeConfirmTime(String runningNumber) {
		if (StringUtils.isNotEmpty(runningNumber)) {
			SaPaymentDetailTotal total = new SaPaymentDetailTotal();
			total.setRunningNumber(runningNumber);
			return saPaymentDetailTotalDao.financeConfirmTime(total);
		}
		return 0;
	}

	public static final String[] CHARGING_ITEMIDS_MONTH = { "cab1", "cab237", "cab3", "cab6", "cab105", "cab106",
			"cab27", "cab102", "cab255", "cab8f6e5ea2c4db4cfaa7e465435df06173", "cab318", "cab103", "cab255",

			"cku6", "cku102", "ckuda8f743b648c4f369fc19ebb31662ad1",

			"cabde2d33b8bb014867968c31689dbc71bb", "cab2c4e95dbc3ce4d5b898247f172594866",
			"cab3b51f5e483c348c7b465086060032324", "cab286", "cab287", "cab288", "cab289", "cab290", "cab291", "cab292",
			"cab293", "cab294", "cab295", "cab296", "cab1111", "cab63", "cab308", "cab309",
			// "cab200",
			"cabda8f743b648c4f369fc19ebb31662ad1", "cabe2e26a94169c41e588551ce9d9197fd6",

	};
	public static final String[] CHARGING_ITEMIDS_DAY = { "cku2", "cab0", "cku3", "cku80", "cab202",
			"cku57053cefa38149a8a04d4ae6d8a68741", "cab57053cefa38149a8a04d4ae6d8a68741",
			"cab992c2008746f43c2be9c484d150008a4", "cab99", // 配种证明加急 240
			"cab12" // 配种证明加急 120

	};

	/**
	 * 分摊月底确认收入
	 * 
	 * @return
	 */
	// @Transactional(readOnly = false)
	public int revenueRecognition() {
		int i = 0;
		String date = DateUtils.getDate();
		// 月末
		String endDayOfMonth = DateUtils.getEndDayOfMonthStr();
		if (date.equals(endDayOfMonth)) {
			List<SaPaymentDetailTotal> monthList = dao.findByIdSet(CHARGING_ITEMIDS_MONTH, date, "");
			if (!Collections3.isEmpty(monthList)) {
				for (SaPaymentDetailTotal sa : monthList) {
					i += revenueRecognition(sa.getId(), sa.getChargeDate());
					// if(sa.getChargeDate().equals(DateUtils.formatDate(endDayOfMonth,
					// "yyyy-MM-dd"))){
					// }
				}
			}
		}

		// if(date.equals(DateUtils.formatDate(endDayOfMonth, "yyyy-MM-dd"))){
		// }
		// 当日缴费
		List<SaPaymentDetailTotal> dayList = dao.findByIdSet(CHARGING_ITEMIDS_DAY, "", date);
		if (!Collections3.isEmpty(dayList)) {
			for (SaPaymentDetailTotal data : dayList) {
				if (isRevenue(data)) {
					i += revenueRecognition(data.getId(), data.getPaymentTime());
				}
			}
		}
		return i;
	}

	private boolean isRevenue(SaPaymentDetailTotal data) {
		// 加急配种证明4中情况
		if ("cab99".equals(data.getChargeItemId()) && "240.00".equals(data.getPaymentMoney())) {
			return false;
		}
		if ("cab12".equals(data.getChargeItemId()) && "120.00".equals(data.getPaymentMoney())) {
			return false;
		}

		return true;
	}

	@Transactional(readOnly = false)
	private int revenueRecognition(String id, Date date) {
		return dao.updateRevenueRecognition(id, date);
	}
}