/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.finance.entity;

import org.hibernate.validator.constraints.Length;
import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;

import com.thinkgem.jeesite.common.persistence.DataEntity;

/**
 * 代收代入Entity
 * @author lyy
 * @version 2016-08-16
 */
public class PaymentPayOther extends DataEntity<PaymentPayOther> {
	
	private static final long serialVersionUID = 1L;
	private String runningNum;		// 流水号
	private String payee;		// 收款人
	private String drawee;		// 付款人
	private String price;		// 金额
	private Date addTime;		// 缴费时间

	private Date startAddTime;	//查询开始时间
	private Date endAddTime;	 //查询结束时间


	private String payeeName;
	private String draweeName;
	public PaymentPayOther() {
		super();
	}

	public PaymentPayOther(String id){
		super(id);
	}

	@Length(min=0, max=100, message="流水号长度必须介于 0 和 100 之间")
	public String getRunningNum() {
		return runningNum;
	}

	public void setRunningNum(String runningNum) {
		this.runningNum = runningNum;
	}
	
	@Length(min=0, max=64, message="收款人长度必须介于 0 和 64 之间")
	public String getPayee() {
		return payee;
	}

	public void setPayee(String payee) {
		this.payee = payee;
	}
	
	@Length(min=0, max=64, message="付款人长度必须介于 0 和 64 之间")
	public String getDrawee() {
		return drawee;
	}

	public void setDrawee(String drawee) {
		this.drawee = drawee;
	}
	
	public String getPrice() {
		return price;
	}

	public void setPrice(String price) {
		this.price = price;
	}
	
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getAddTime() {
		return addTime;
	}

	public void setAddTime(Date addTime) {
		this.addTime = addTime;
	}
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getStartAddTime() {
		return startAddTime;
	}

	public void setStartAddTime(Date startAddTime) {
		this.startAddTime = startAddTime;
	}
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getEndAddTime() {
		return endAddTime;
	}

	public void setEndAddTime(Date endAddTime) {
		this.endAddTime = endAddTime;
	}

	public String getPayeeName() {
		return payeeName;
	}

	public void setPayeeName(String payeeName) {
		this.payeeName = payeeName;
	}

	public String getDraweeName() {
		return draweeName;
	}

	public void setDraweeName(String draweeName) {
		this.draweeName = draweeName;
	}
}