/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.finance.entity;

import org.hibernate.validator.constraints.Length;
import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;

import com.thinkgem.jeesite.common.persistence.DataEntity;

/**
 * 订单项目Entity
 * @author lyy
 * @version 2016-08-04
 */
public class PaymentOrderProject extends DataEntity<PaymentOrderProject> {
	
	private static final long serialVersionUID = 1L;
	private String name;		// 项目名称
	private Date startDate;		// 项目时间
	private String address;		// 项目地址
	private String isTop;		// 是否置顶
	private String isValid;		// 是否有效
	private Date addTime;		// 添加时间

	private String type;
	
	public PaymentOrderProject() {
		super();
	}

	public PaymentOrderProject(String id){
		super(id);
	}

	@Length(min=0, max=200, message="项目名称长度必须介于 0 和 200 之间")
	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}
	
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getStartDate() {
		return startDate;
	}

	public void setStartDate(Date startDate) {
		this.startDate = startDate;
	}
	
	@Length(min=0, max=255, message="项目地址长度必须介于 0 和 255 之间")
	public String getAddress() {
		return address;
	}

	public void setAddress(String address) {
		this.address = address;
	}
	
	@Length(min=0, max=50, message="是否置顶长度必须介于 0 和 50 之间")
	public String getIsTop() {
		return isTop;
	}

	public void setIsTop(String isTop) {
		this.isTop = isTop;
	}
	
	@Length(min=0, max=50, message="是否有效长度必须介于 0 和 50 之间")
	public String getIsValid() {
		return isValid;
	}

	public void setIsValid(String isValid) {
		this.isValid = isValid;
	}
	
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getAddTime() {
		return addTime;
	}

	public void setAddTime(Date addTime) {
		this.addTime = addTime;
	}

	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}
}