package com.cku.oa.dog.service;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.ui.Model;
import org.springframework.util.CollectionUtils;

import com.alibaba.fastjson.JSONObject;
import com.cku.core.PageResultDto;
import com.cku.core.RESTResponse;
import com.cku.core.ResultDto;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.clubdog.entity.ClubDog;
import com.cku.oa.clubdog.service.ClubDogService;
import com.cku.oa.dog.dao.DogPedigreeCertifiedChangeDao;
import com.cku.oa.dog.dao.DogVideoAppraisalDao;
import com.cku.oa.dog.entity.DogBirthCertificate;
import com.cku.oa.dog.entity.DogChipChange;
import com.cku.oa.dog.entity.DogPedigreeCertifiedChange;
import com.cku.oa.dog.entity.DogVideoAppraisal;
import com.cku.oa.dog.entity.DogVideoAppraisalFile;
import com.cku.oa.dog.util.VodUtil;
import com.cku.oa.finance.entity.PaymentCart;
import com.cku.oa.finance.entity.PaymentChargingItem;
import com.cku.oa.finance.entity.PaymentOrderDetail;
import com.cku.oa.finance.service.PaymentCartService;
import com.cku.oa.finance.service.PaymentChargingItemService;
import com.cku.oa.sys.code.SysCodeUtil;
import com.cku.oa.sys.entity.LoginServer;
import com.cku.oa.sys.entity.Org;
import com.cku.oa.sys.entity.OrgChip;
import com.cku.oa.sys.entity.user.Member;
import com.cku.oa.sys.service.ExpressQueueService;
import com.cku.oa.sys.service.LoginServerService;
import com.cku.oa.sys.service.OrgChipService;
import com.cku.oa.sys.service.user.MemberService;
import com.cku.oa.sys.util.DateUtils;
import com.cku.oa.sys.util.MemberUtil;
import com.cku.oa.sys.zalog.SysContext;
import com.cku.partner.sys.model.PartnerLoginUserInfo;
import com.cku.restful.v1.dog.model.RestVideoAppraisalListResponse;
import com.cku.restful.v1.dog.model.RestVideoAppraisalPostResponse;
import com.cku.restful.v1.dog.model.RestVideoAppraisalResponse;
import com.cku.restful.v1.dog.model.VideoMemberResponse;
import com.cku.restful.v1.dog.vo.DogVideoAppraisalVo;
import com.cku.restful.v1.dog.vo.DogVideoBindChipVo;
import com.cku.restful.v1.dog.vo.ImgVo;
import com.cku.restful.v1.dog.vo.MemberVo;
import com.cku.restful.v1.dog.vo.VodVo;
import com.cku.restful.v1.sys.service.RestIDCardService;
import com.cku.restful.v1.sys.utils.BeanUtil;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import com.thinkgem.jeesite.common.utils.PropertiesLoader;
import com.thinkgem.jeesite.modules.sys.utils.DictUtils;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

@Service
@Transactional(readOnly = true)
public class DogVideoAppraisalService extends CrudService<DogVideoAppraisalDao, DogVideoAppraisal> {

	private static final String BUSINESS_NAME = "线上犬只鉴定";

	private static final String DOG_VIDEO_APPRAISAL = "dog_video_appraisal@All";

	private static final String DOG_CHIP_CHANGE = "dog_chip_change@chipFee";

	private static final String DOG_VIDEO_APPRAISAL_FREE = "dog_video_appraisal@free";

	private static final String DOG_CHIP_EMBED = "dog_chip_change@embedChipFee";

	@Autowired
	private RestIDCardService restIDCardService;

	@Autowired
	private MemberService memberService;

	@Autowired
	private DogVideoAppraisalFileService dogVideoAppraisalFileService;

	@Autowired
	private PaymentChargingItemService paymentChargingItemService;

	@Autowired
	private PaymentCartService paymentCartService;

	@Autowired
	private ExpressQueueService expressQueueService;
	
	@Autowired
	private DogBirthCertificateService dogBirthCertificateService;

	@Autowired
	public LoginServerService loginServerService;
	
	@Autowired
	public DogChipChangeService dogChipChangeService;
	
	@Autowired
	public OrgChipService orgChipService;
	
	@Autowired
	public DogPedigreeCertifiedChangeDao dogPedigreeCertifiedChangeDao;
	
	@Autowired
	public ClubDogService clubDogService;
	
//	@Autowired
//	public ClubMemberService clubMemberService;

	private static PropertiesLoader loader = new PropertiesLoader("config.properties");

	public ResultDto<VideoMemberResponse> getMember(String memberCode) {
		Member member = memberService.getByMemberCode(memberCode);
		if (member == null) {
			return ResultDto.error(-1, "会员编号无效");
		}
		VideoMemberResponse resp = new VideoMemberResponse();
		resp.setMemberCode(member.getMemberCode());
		resp.setMemberName(member.getName());
		resp.setMobile(member.getMobile());
		resp.setStatus(MemberUtil.isActiveMember(member));
		return ResultDto.success(resp);
	}
	
	@Transactional
	public void bindChip(DogVideoBindChipVo vo) {
		
		this.checkChip(vo.getChipNo());
		// 生产护照号
		Map<String, String> result = dogBirthCertificateService.createCabCode("-1", vo.getChipNo());
		String cabPassport = result.get("cabPassport");
		
		DogVideoAppraisal dogVideoAppraisal = new DogVideoAppraisal();
		dogVideoAppraisal.setPassportNo(cabPassport);
		dogVideoAppraisal.setId(vo.getId());
		dogVideoAppraisal.setChipNo(vo.getChipNo());
		dogVideoAppraisal.setResolveStatus("1");
		dao.bindChip(dogVideoAppraisal);
	}
	
	
	
	private void checkChip(String identificationFlag) throws ZAException {
		PartnerLoginUserInfo loginPartner = UserUtils.getLoginPartner();
//		Org org = (Org) UserUtils.getSession().getAttribute("org");
//		String orgId = org.getId();
		DogBirthCertificate birth = dogBirthCertificateService.getByIdentificationFlag(identificationFlag);
		DogChipChange chipChange = dogChipChangeService.getByIdentificationFlag(identificationFlag);
		ClubDog dogClub = clubDogService.getByIdentificationFlag(identificationFlag);
		DogPedigreeCertifiedChange dogPedigreeCertifiedChange = dogPedigreeCertifiedChangeDao
				.getByDogChipCode(identificationFlag);
		if (birth != null || chipChange != null || dogPedigreeCertifiedChange != null || dogClub != null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该芯片已经在CKU注册!!");
		}
		OrgChip orgChip = orgChipService.getByOrgAndIdflag(loginPartner.getId(), identificationFlag);
		if (orgChip == null) {
			String tuijiansren = loginPartner.getTuijianren();
			if(StringUtils.isNotBlank(tuijiansren)){
				OrgChip forgChip = orgChipService.getByOrgAndIdflag(tuijiansren, identificationFlag);
				if(forgChip == null){
					throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该芯片未在CKU备案，请使用俱乐部专用芯片！");
				}
			}else {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该芯片未在CKU备案，请使用俱乐部专用芯片！");
			}
		} else {
			String invalid = orgChip.getInvalid();
			if ("1".equals(invalid)) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该芯片已申请作废，如有疑问请与协会联系！");
			}
		}
	}

	public DogVideoAppraisal get(String id) {
		return super.get(id);
	}

	public List<DogVideoAppraisal> findList(DogVideoAppraisal dogVideoAppraisal) {
		return super.findList(dogVideoAppraisal);
	}

	public Page<DogVideoAppraisal> findPage(Page<DogVideoAppraisal> page, DogVideoAppraisal dogVideoAppraisal) {
		return super.findPage(page, dogVideoAppraisal);
	}

	@Transactional(readOnly = false)
	public void save(DogVideoAppraisal dogVideoAppraisal) {
		super.save(dogVideoAppraisal);
	}

	@Transactional(readOnly = false)
	public void delete(DogVideoAppraisal dogVideoAppraisal) {
		super.delete(dogVideoAppraisal);
	}

	@Transactional(readOnly = false)
	public void resolve(DogVideoAppraisal dogVideoAppraisal) {
		DogVideoAppraisal obj = this.get(dogVideoAppraisal.getId());
		if (!obj.getReviewState().equals("1")) {

		}
		dao.resolve(dogVideoAppraisal);
	}

	public PageResultDto<RestVideoAppraisalListResponse> getList(HttpServletRequest request) {

		String pageNo = request.getParameter("pageNo");
		String pageSize = request.getParameter("pageSize");
		String source = request.getParameter("source");
		String keyword = request.getParameter("keyword");
		// 参数校验
		int pageNoInt = 1;
		int pageSizeInt = 10;
		try {
			if (StringUtils.isNotBlank(pageNo)) {
				pageNoInt = Integer.parseInt(pageNo);
			}
			if (StringUtils.isNotBlank(pageSize)) {
				pageSizeInt = Integer.parseInt(pageSize);
			}
		} catch (Exception e) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "pageNo和pageSize必须都为数字");
		}
		DogVideoAppraisal dogVideoAppraisal = new DogVideoAppraisal();
		// app 可申请的鉴定数据
		if (!StringUtils.isEmpty(source) && "show".equals(source)) {
			dogVideoAppraisal.setReviewState("1");
			Member member = UserUtils.getLoginMember();
			dogVideoAppraisal.setMemberCode(member.getMemberCode());
			dogVideoAppraisal.setKeyword(keyword);
			dogVideoAppraisal.setSource(source);
		} else {
			// 俱乐部已鉴定数据
			PartnerLoginUserInfo info = UserUtils.getLoginPartner();
			dogVideoAppraisal.setClubCode(info.getMemberCode());
		}
		// 组装查询
		Page<DogVideoAppraisal> page = new Page<DogVideoAppraisal>();
		page.setPageNo(pageNoInt);
		page.setPageSize(pageSizeInt);
		dogVideoAppraisal.setPage(page);
		Page<DogVideoAppraisal> result = this.findPage(page, dogVideoAppraisal);
		List<DogVideoAppraisal> appraisalList = result.getList();
		List<RestVideoAppraisalListResponse> resultVo = new ArrayList<>();
		// convert resp
		for (DogVideoAppraisal appraisal : appraisalList) {
			RestVideoAppraisalListResponse vo = new RestVideoAppraisalListResponse();
			BeanUtil.copyProperties(vo, appraisal, "yyyy-MM-dd");
			vo.setVideoAppraisalId(appraisal.getId());
			vo.setCardType(UserUtils.getMemberCardType(appraisal.getMemberCode()));
			vo.setChipFlag("1".equals(appraisal.getReviewState()) && StringUtils.isEmpty(appraisal.getChipNo()));
			resultVo.add(vo);
		}
		return PageResultDto.success(resultVo, result.getCount());
	}

	@Transactional
	public ResultDto<RestVideoAppraisalPostResponse> post(DogVideoAppraisalVo vo, HttpServletRequest request) {
		// 条件验证
		validateParameter(vo);
		String newMemberFlag = vo.getNewMemberFlag();
		// 注册新会员信息、验证业务会员信息
		Member sysMember = null;
		if (!"0".equals(newMemberFlag)) { // 注册新会员
			checkCordNo(vo.getMemberVo(), request);
			LoginServer loginServer = loginServerService.getLoginServerByDogBreed(vo.getDogBreed());
			sysMember = buildMember(vo);
			sysMember.setMemberSite(loginServer.getMemberSite());
			memberService.save(sysMember);
		} else {
			sysMember = new Member();
			Member member = memberService.getByMemberCode(vo.getMemberVo().getMemberCode());
			if (member == null) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "会员号错误");
			}
			sysMember.setMemberCode(vo.getMemberVo().getMemberCode());
			sysMember.setName(vo.getMemberVo().getMemberName());
		}
		// 验证登陆人会员
		PartnerLoginUserInfo loginPartner = UserUtils.getLoginPartner();
		if (loginPartner.getId() == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "无登录信息或登陆者无俱乐部身份，请重新登陆！");
		}
		Member loginMember = memberService.getByMemberCode(loginPartner.getMemberCode());
		if (loginMember == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "会员号错误");
		}

		// 生成业务数据
		DogVideoAppraisal dogVideoAppraisal = buildDogVideoAppraisal(sysMember, vo);
		this.save(dogVideoAppraisal);
		// save 图片
		for (ImgVo img : vo.getImgIds()) {
			DogVideoAppraisalFile imgFile = new DogVideoAppraisalFile();
			imgFile.setFildId(img.getImgId());
			imgFile.setAppraisalId(dogVideoAppraisal.getId());
			imgFile.setFileType("1");
			imgFile.setFileSort(img.getSort());
			dogVideoAppraisalFileService.save(imgFile);
		}

		// save 视频
		for (VodVo vod : vo.getVods()) {
			DogVideoAppraisalFile vodFile = new DogVideoAppraisalFile();
			vodFile.setFileType("2");
			vodFile.setAppraisalId(dogVideoAppraisal.getId());
			vodFile.setFildId(vod.getVodName());
			vodFile.setBusinessCode(vod.getBusinessCode());
			dogVideoAppraisalFileService.save(vodFile);
		}

		// 购物车
		List<PaymentCart> paymentCarts = buildPaymentCart(dogVideoAppraisal);
		String ids = "";
		BigDecimal db = new BigDecimal(0);
		for (PaymentCart cart : paymentCarts) {
			paymentCartService.addToCartByClub(cart, "1082", dogVideoAppraisal.getClubCode());
			ids += cart.getId() + ",";
			db = db.add(new BigDecimal(cart.getTotalPrice()));
		}
		RestVideoAppraisalPostResponse resp = this.buildPostResp(db.toPlainString(), ids, sysMember, dogVideoAppraisal);
		return ResultDto.success(resp);
	}

	private RestVideoAppraisalPostResponse buildPostResp(String price, String cartids, Member sysMember,
			DogVideoAppraisal dogVideoAppraisal) {
		RestVideoAppraisalPostResponse resp = new RestVideoAppraisalPostResponse();
		resp.setMemberCode(sysMember.getMemberCode());
		resp.setMemberName(sysMember.getName());
		Member member = memberService.getByMemberCode(sysMember.getMemberCode());
		resp.setCardType(UserUtils.getMemberCardType(member));

		resp.setDogBreed(dogVideoAppraisal.getDogBreed());
		resp.setDogBreedCn(dogVideoAppraisal.getDogBreedCn());
		resp.setDogColor(dogVideoAppraisal.getDogColor());
		resp.setDogColorCn(dogVideoAppraisal.getDogColorCn());
		resp.setDogGender(dogVideoAppraisal.getDogGender());
		resp.setDogName(dogVideoAppraisal.getDogName());
		resp.setDogNose(dogVideoAppraisal.getDogNose());
		resp.setPrice(price);
		resp.setCartId(cartids.endsWith(",") ? cartids.substring(0, cartids.length()) : cartids);
		resp.setDogBirth(com.cku.util.DateUtils.dateToStr(dogVideoAppraisal.getDogBirth()));
		return resp;
	}

	private List<PaymentCart> buildPaymentCart(DogVideoAppraisal dogVideoAppraisal) {
		List<PaymentCart> carts = new ArrayList<>();
		// 2020-07-20 视频鉴定订单收费项：
		// 线上鉴定犬登记费 299元
		// 芯片费 50元
		// 电子芯片埋置服务费 100元
		// 线上鉴定犬登记费（减免）-161元
		PaymentCart paymentCart = new PaymentCart();
		PaymentChargingItem paymentChargingItem = getDogAppraisalItem();
		paymentCart.setChargingItemId(paymentChargingItem.getId());
		paymentCart.setChargingItemName(paymentChargingItem.getName());
		paymentCart.setNum("1");
		paymentCart.setPrice(paymentChargingItem.getPrice());
		paymentCart.setTotalPrice(paymentChargingItem.getPrice());
		paymentCart.setBusinessTable("dog_video_appraisal");
		paymentCart.setBusinessIds(dogVideoAppraisal.getId());
		String timeMillis = Long.toString(System.currentTimeMillis());
		paymentCart.setBusinessOrderCode(timeMillis);

		PaymentCart chipCart = new PaymentCart();
		PaymentChargingItem chipItem = getChipItem();
		chipCart.setChargingItemId(chipItem.getId());
		chipCart.setChargingItemName(chipItem.getName());
		chipCart.setNum("1");
		chipCart.setPrice(chipItem.getPrice());
		chipCart.setTotalPrice(chipItem.getPrice());
		chipCart.setBusinessTable("dog_video_appraisal");
		chipCart.setBusinessIds(dogVideoAppraisal.getId());
		chipCart.setBusinessOrderCode(timeMillis);

		PaymentCart videoFreeCart = new PaymentCart();
		PaymentChargingItem videoFreeItem = getVideoFreeItem();
		videoFreeCart.setChargingItemId(videoFreeItem.getId());
		videoFreeCart.setChargingItemName(videoFreeItem.getName());
		videoFreeCart.setNum("1");
		videoFreeCart.setPrice(videoFreeItem.getPrice());
		videoFreeCart.setTotalPrice(videoFreeItem.getPrice());
		videoFreeCart.setBusinessTable("dog_video_appraisal");
		videoFreeCart.setBusinessIds(dogVideoAppraisal.getId());
		videoFreeCart.setBusinessOrderCode(timeMillis);

		PaymentCart chipEmbedCart = new PaymentCart();
		PaymentChargingItem chipEMbedItem = getChipEmbedItem();
		chipEmbedCart.setChargingItemId(chipEMbedItem.getId());
		chipEmbedCart.setChargingItemName(chipEMbedItem.getName());
		chipEmbedCart.setNum("1");
		chipEmbedCart.setPrice(chipEMbedItem.getPrice());
		chipEmbedCart.setTotalPrice(chipEMbedItem.getPrice());
		chipEmbedCart.setBusinessTable("dog_video_appraisal");
		chipEmbedCart.setBusinessIds(dogVideoAppraisal.getId());
		chipEmbedCart.setBusinessOrderCode(timeMillis);

		carts.add(chipEmbedCart);
		carts.add(videoFreeCart);
		carts.add(chipCart);
		carts.add(paymentCart);
		return carts;
	}

	public PaymentChargingItem getChipEmbedItem() {
		return paymentChargingItemService.getByShortName(DOG_CHIP_EMBED);
	}

	public PaymentChargingItem getVideoFreeItem() {
		return paymentChargingItemService.getByShortName(DOG_VIDEO_APPRAISAL_FREE);
	}

	public PaymentChargingItem getChipItem() {
		return paymentChargingItemService.getByShortName(DOG_CHIP_CHANGE);
	}

	public PaymentChargingItem getDogAppraisalItem() {
		return paymentChargingItemService.getByShortName(DOG_VIDEO_APPRAISAL);
	}

	private DogVideoAppraisal buildDogVideoAppraisal(Member member, DogVideoAppraisalVo vo) {
		DogVideoAppraisal obj = new DogVideoAppraisal();
		obj.setReviewState("0");
		PartnerLoginUserInfo info = UserUtils.getLoginPartner();
		obj.setClubCode(info.getMemberCode());
		obj.setDogBirth(vo.getDogBirth());
		obj.setDogBreed(vo.getDogBreed());
		obj.setDogBreedCn(vo.getDogBreedCn());
		obj.setDogColor(vo.getDogColor());
		obj.setDogColorCn(vo.getDogColorCn());
		obj.setDogGender(vo.getDogGender());
		obj.setMemberCode(member.getMemberCode());
		obj.setMemberName(member.getName());
		obj.setDogName(vo.getDogName());
		obj.setDogNose(vo.getDogNose());
		obj.setPaymentState("1");
		obj.setReviewState("5");
		obj.setPrintStatus("0");
		obj.setResolveStatus("0");
		obj.setAppraisalNo(String.valueOf(System.currentTimeMillis()));
		return obj;
	}

	private Member buildMember(DogVideoAppraisalVo vo) {
		String dogBreed = vo.getDogBreed();
		Member sysMember = new Member();
		String memberCode = SysCodeUtil.getMemberCode();
		if ("15C".equals(dogBreed)) {
			memberCode = "MC" + memberCode;
		}
		if ("292".equals(dogBreed)) {
			memberCode = "DC" + memberCode;
		}
		sysMember.setGender("male");
		sysMember.setProvince(vo.getMemberVo().getProvince());
		sysMember.setCity(vo.getMemberVo().getCity());
		sysMember.setArea(vo.getMemberVo().getArea());
		sysMember.setAddress(vo.getMemberVo().getStreet());
		sysMember.setStreet(vo.getMemberVo().getStreet());

		sysMember.setMemberType("basic");
		sysMember.setMemberCode(memberCode);
		sysMember.setMobile(vo.getMemberVo().getMobile());
		sysMember.setMemberSite("");
		sysMember.setName(vo.getMemberVo().getMemberName());
		sysMember.setCardNo(vo.getMemberVo().getCardNo());
		sysMember.setMemberCardType("100");
		return sysMember;
	}

	private void checkCordNo(MemberVo vo, HttpServletRequest request) {
		Integer i = restIDCardService.validateIDCard(null, vo.getCardNo(), vo.getMemberName(), "", true);
		if (i != 1) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "身份信息验证失败");
		}
	}

	// 视频鉴定退款详情
	public RESTResponse getRefundList(Map<String, List<PaymentOrderDetail>> collect) {
		PaymentChargingItem dogAppraisalItem = this.getDogAppraisalItem();
		PaymentOrderDetail paymentOrderDetail = new PaymentOrderDetail();
		collect.entrySet().forEach(i -> {
			i.getValue().forEach(j -> {
				// 视频鉴定
				if (j.getChargingItemId().equals(dogAppraisalItem.getId())
						&& j.getBusinessTable().equals("dog_video_appraisal")) {
					System.out.println(j.getBusinessTable());
					paymentOrderDetail.setBusinessIds(j.getBusinessIds());
					paymentOrderDetail.setBusinessTable(j.getBusinessTable());
				}
			});
		});
		// 返回数据
		List<RestVideoAppraisalResponse> list = new ArrayList<>();
		// 不存在则返回空集合
		if (paymentOrderDetail.getBusinessIds() == null) {
			return new RESTResponse("data", list);
		}
		// 条件
		DogVideoAppraisal dogVideoAppraisal = new DogVideoAppraisal();
		dogVideoAppraisal.setDelFlag("0");
		dogVideoAppraisal.setId(paymentOrderDetail.getBusinessIds());
		List<DogVideoAppraisal> lists = this.findList(dogVideoAppraisal);
		// 转换数据
		for (DogVideoAppraisal dogVideoAppraisalList : lists) {
			RestVideoAppraisalResponse vo = new RestVideoAppraisalResponse();
			BeanUtil.copyProperties(vo, dogVideoAppraisalList, "yyyy-MM-dd");
			SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
			vo.setCreateDate(simpleDateFormat.format(dogVideoAppraisalList.getCreateDate()));
			vo.setReviewState(DictUtils.getDictLabel(vo.getReviewState(), "dog_appraisal_review_state", ""));
			list.add(vo);
		}
		return new RESTResponse("data", list);
	}

	public DogVideoAppraisal getInfo(DogVideoAppraisal dogVideoAppraisal) {
		// 查询鉴定信息
		DogVideoAppraisal info = this.get(dogVideoAppraisal.getId());
		// 查询图片信息
		DogVideoAppraisalFile imgFile = new DogVideoAppraisalFile();
		imgFile.setAppraisalId(info.getId());
		imgFile.setFileType("1");
		List<DogVideoAppraisalFile> imgList = dogVideoAppraisalFileService.findList(imgFile);
		info.setImgs(imgList);
		// 查询视频信息
		DogVideoAppraisalFile vodFile = new DogVideoAppraisalFile();
		vodFile.setAppraisalId(info.getId());
		vodFile.setFileType("2");
		vodFile.setBusinessCode("partnerAppraisal");
		List<DogVideoAppraisalFile> vodList = dogVideoAppraisalFileService.findList(vodFile);
		if (!CollectionUtils.isEmpty(vodList)) {
			info.setVodUrl(VodUtil.getVodUrl("partnerAppraisal", vodList.get(0).getFildId()));
		} else {
			info.setVodUrl("");
		}
		info.setDogGenderDesc("1".equals(info.getDogGender()) ? "公" : "母");
		return info;
	}


	private void validateParameter(DogVideoAppraisalVo vo) {
		// 出生日期与申请日期时间大于等于三个月
		if (DateUtils.isInXMounth(vo.getDogBirth(), 3)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "视频鉴定需犬只年龄不小于三个月龄");
		}
		MemberVo memberVo = vo.getMemberVo();
		if (memberVo == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "会员信息缺失");
		}

		if ("1".equals(vo.getNewMemberFlag())
				&& (StringUtils.isEmpty(memberVo.getArea()) || StringUtils.isEmpty(memberVo.getCardNo())
						|| StringUtils.isEmpty(memberVo.getCity()) || StringUtils.isEmpty(memberVo.getMobile())
						|| StringUtils.isEmpty(memberVo.getProvince()) || StringUtils.isEmpty(memberVo.getStreet()))) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "会员信息缺失");
		}

		if ("0".equals(vo.getNewMemberFlag())) { // 老会员验证犬种

			if (StringUtils.isEmpty(memberVo.getMemberCode()) || StringUtils.isEmpty(memberVo.getMemberName())) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "会员信息缺失");
			}

			if (vo.getMemberVo().getMemberCode().contains("MC") && !"15C".equals(vo.getDogBreed())) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "会员类型和犬种类型不同");
			}
			if (vo.getMemberVo().getMemberCode().contains("DC") && !"292".equals(vo.getDogBreed())) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "会员类型和犬种类型不同");
			}
		}
	}

	@Transactional
	public String print(DogVideoAppraisal dogVideoAppraisal, Model model) {
		DogVideoAppraisal info = this.getInfo(dogVideoAppraisal);
		if (StringUtils.isEmpty(info.getChipNo()) || StringUtils.isEmpty(info.getPassportNo())) {
			throw new ZAException(ZAErrorCode.ZA_ERC_UNKNOWN, "请先生成芯片号/护照号");
		}
		info.setAppraisalDate(com.thinkgem.jeesite.common.utils.DateUtils.formatDate(info.getCreateDate()));
		model.addAttribute("info", info);
		info.setPrintStatus("1");
		dao.update(info);
		// 通过状态机记录日志
		SysContext sysContext = new SysContext(null, null, null);
		sysContext.noStateExecute(sysContext, BUSINESS_NAME + "打印", info.getMemberCode(), "dog_appraisal", info.getId(),
				info.getRunningNumber(), (str) -> {
				});
		// 添加待邮寄物品
		expressQueueService.push(info.getMemberCode(), info.getRunningNumber(), "线上鉴定证书", info.getPassportNo(),
				"dog_video_appraisal", info.getId(), "");

		return "oa/dog/dogvideoappraisal/dogVideoAppraisalPrint";
	}

	@Transactional
	public void resetPrint(DogVideoAppraisal dogVideoAppraisal, Model model) {
		DogVideoAppraisal info = this.getInfo(dogVideoAppraisal);
		info.setPrintStatus("0");
		dao.update(info);
	}

	public void updateAppraisalStatus(String id) {
		dao.updateAppraisalStatus(id);
	}

}