/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.dog.dao;

import java.util.Date;
import java.util.List;

import org.apache.ibatis.annotations.Param;

import com.cku.oa.dog.entity.Dog;
import com.cku.oa.dog.entity.DuplicateDog;
import com.cku.restful.v1.dog.model.InsuranceDog;
import com.thinkgem.jeesite.common.persistence.CrudDao;
import com.thinkgem.jeesite.common.persistence.annotation.MyBatisDao;

/**
 * 犬只信息管理DAO接口
 *
 * @author zhuoHeng
 * @version 2016-08-03
 */
@MyBatisDao
public interface DogDao extends CrudDao<Dog> {

	Dog getByPedigreeCertifiedCode(String pedigreeCertifiedCode);

	Dog getByPedigreeCertifiedCodeOrEn(String pedigreeCertifiedCode);

	Dog getByPedigreeCertifiedCodeIncludeDel(String pedigreeCertifiedCode);

	Dog getByIdentificationFlag(String identificationFlag);
	
	List<Dog> getByIdentificationFlagList(String identificationFlag);

	Dog getNewOneByIdentificationFlag(@Param("identificationFlag") String identificationFlag);


	/**
	 * @Description：变更犬主信息
	 * @author: zhuoHeng
	 * @version: 2016年8月24日 下午8:23:17
	 */
	void updateDogOwner(Dog dog);

	Dog getByPedigreeCertifiedEn(@Param("pedigreeCertifiedEn") String pedigreeCertifiedEn);

	Dog getCkuDogByPedigreeCertifiedEnOrCode(@Param("pedigreeCertifiedEn") String pedigreeCertifiedEn);

	Dog getCkuDogByPedigreeCertifiedEn(@Param("pedigreeCertifiedEn") String pedigreeCertifiedEn);

	/**
	 * @description: 更新printState字段
	 * @author: laiguanglong
	 * @date: 2016年8月30日 下午5:38:08
	 */
	void updatePrintState(Dog dog);

	// 血统证书号 唯一性校验
	List<Dog> getBycode(String pedigreeCertifiedCode);

	// 芯片号 唯一性校验
	List<Dog> getByFlag(String identificationFlag);

	// g根据父母配种证明号查询国外证书号
	List<Dog> getByFmdog(@Param("fmdogBreedCertifiedCode") String fmdogBreedCertifiedCode);

	// 根据出生纸编号查询犬只
	Dog getByBirthCertificateLevelCode(@Param("birthCertificateLevelCode") String birthCertificateLevelCode);
	// 根据出生纸编号查询犬只
	Dog getByBirthCertificateLevelCodeTwo(@Param("birthCertificateLevelCode") String birthCertificateLevelCode);
	/**
	 * @Description：变更犬只芯片号
	 * @author: zhuoHeng
	 * @version: 2016年10月17日 上午9:51:26
	 */
	void updateDogChip(Dog dog);

	List<Dog> getfm(@Param("overseasPedigreeCertified") String overseasPedigreeCertified);

	// 根据会员号查询犬只数量
	int countByMemberCode(@Param("memberCode") String memberCode);

	// 查询会员名下公犬都有哪些犬种
	List<String> getMaleDogBreedListByMemberCode(@Param("memberCode") String memberCode);

	// 查询会员名下母犬都有哪些犬种
	List<String> getFemaleDogBreedListByMemberCode(@Param("memberCode") String memberCode);

	// 查询会员名下犬都有哪些犬种
	List<String> getDogBreedListByMemberCode(@Param("memberCode") String memberCode);

	// 查询会员名下某品种年龄在1到10岁之间的公犬信息
	List<Dog> getMaleDogByMemberCodeAndDogBreed(@Param("memberCode") String memberCode,
			@Param("dogBreed") String dogBreed, @Param("pageNo") Integer pageNo, @Param("pageSize") Integer pageSize);

	// 查询会员名下某品种年龄在1到10岁之间的公犬信息
	int getMaleDogCountByMemberCodeAndDogBreed(@Param("memberCode") String memberCode,
			@Param("dogBreed") String dogBreed);

	// 查询会员名下未添加种犬的犬信息
	List<Dog> getMyDogByMemberCode(@Param("memberCode") String memberCode, @Param("pageNo") Integer pageNo,
			@Param("pageSize") Integer pageSize);

	// 查询会员名下未添加种犬的犬信息
	long getMyDogCountByMemberCode(@Param("memberCode") String memberCode);

	// 查询会员名下未卖出去的犬信息
	List<Dog> getMyUnsoldDog(@Param("memberCode") String memberCode, @Param("searchKey") String searchKey,
			@Param("pageNo") Integer pageNo, @Param("pageSize") Integer pageSize);

	// 查询会员名下未卖出去的犬信息
	long getMyUnsoldDogCount(@Param("memberCode") String memberCode, @Param("searchKey") String searchKey);

	// 查询会员名下卖出去的犬信息
	List<Dog> getMySoldDog(@Param("memberCode") String memberCode, @Param("searchKey") String searchKey,
			@Param("pageNo") Integer pageNo, @Param("pageSize") Integer pageSize);

	// 查询会员名下卖出去的犬信息
	long getMySoldDogCount(@Param("memberCode") String memberCode, @Param("searchKey") String searchKey);

	// 查询会员名下全部(包含已卖、未卖出去)的犬信息
	long getMyAllDogCount(@Param("memberCode") String memberCode, @Param("searchKey") String searchKey);

	// 查询会员名下全部(包含已卖、未卖出去)的犬数量
	List<Dog> getMyAllDog(@Param("memberCode") String memberCode, @Param("searchKey") String searchKey,
						   @Param("pageNo") Integer pageNo, @Param("pageSize") Integer pageSize);

	// 保存已售犬只
	void saveSoldDog(@Param("dogId") String dogId, @Param("memberCode") String memberCode);

	// 删除已售犬只
	void deleteSoldDog(@Param("dogId") String dogId, @Param("memberCode") String memberCode);

	// 查询会员名下符合配种条件的犬
	List<Dog> getBreedableDog(@Param("memberCode") String memberCode, @Param("gender") String gender,
			@Param("key") String key, @Param("pageNo") Integer pageNo, @Param("pageSize") Integer pageSize,
			@Param("ageFlag") String ageFlag);

	// 查询会员名下符合配种条件的犬数量
	long getBreedableDogCount(@Param("memberCode") String memberCode, @Param("gender") String gender,
			@Param("key") String key, @Param("ageFlag") String ageFlag);

	// 查询会员犬只报名历史
	List<Dog> getApplyHistory(@Param("memberCode") String memberCode, @Param("pageNo") Integer pageNo,
			@Param("pageSize") Integer pageSize);

	// 查询会员犬只报名历史总数
	long getApplyHistoryCount(@Param("memberCode") String memberCode);

	// 宠爱王国保险查询犬只信息
	List<InsuranceDog> getByInsIdentificationFlag(String identificationFlag);

	// 修改犬只FCI赛事编码
	int updateShowDogBreed(Dog dog);

	// 修改犬只代数
	int updateDogGeneration(Dog dog);

	// 根据时间查全部犬只
	List<Dog> findAllListByDate(@Param("startDate") Date stateDate, @Param("endDate") Date endDate);

	// 修改犬只繁殖状态
	int updateDogBusinessBan(Dog dog);

	Dog getOneByIdentificationFlagOrPedigreeCertified(@Param("keyword") String keyword);

	String getDogImgById(@Param("id") String id);


	void updateSecondBreeder(@Param("id")String id,@Param("secondBreeder") String secondBreeder);


	 Dog getByPedigreeCertifiedCodeOrIdentificationFlag(@Param("key")String key);

//	根据父母犬查询该犬只
	List<Dog> getByParents(@Param("key")String key);
    List<Dog> getByFatherDog(@Param("key")String key);
    List<Dog> getByMotherDog(@Param("key")String key);
    List<Dog> getByFmdogBreedCertifiedCode(@Param("key")String key);

    List<Dog> findDogNameByBirthCode(@Param("ids") List<String> ids);
    List<Dog> findDogNameByPedigreeCode(@Param("ids") List<String> pedigreeCodes);

	Long getdogPictureReviewStateCount();

	List<Dog> getPictureReviewStateList(Dog dog);
	
	int deleteByDogIds(@Param("dogIds") List<String> dogIds);
	
	List<DuplicateDog> getDuplicateRecordByBirthCertificateLevelCode();
	
    int deleteDuplicateRecordByBirthCertificateLevelCode(@Param("birthCertificateLevelCode") String birthCertificateLevelCode);

	List<Dog> getAllBirthCertificateLevelCode(@Param("birthCertificateLevelCode") String birthCertificateLevelCode);


	Dog getByDog(Dog dog);

	/**
	 * 更新金质证书信息
	 *
	 * @author yuanshuai
	 * @since 2024/3/12 14:53
	 */
	void updateGoldCertifiedInfo(Dog dog);
	
	List<Dog> findByPedigreeCertifiedCodes(@Param("pedigreeCertifiedCodes") List<String> pedigreeCertifiedCodes);
}