/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.dog.dao;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.apache.ibatis.annotations.MapKey;
import org.apache.ibatis.annotations.Param;

import com.cku.oa.dog.entity.DogBirthCertificate;
import com.cku.oa.dog.entity.DogName;
import com.thinkgem.jeesite.common.persistence.CrudDao;
import com.thinkgem.jeesite.common.persistence.annotation.MyBatisDao;

/**
 * 出生证明DAO接口
 *
 * @author lgl
 * @version 2016-08-04
 */
@MyBatisDao
public interface DogBirthCertificateDao extends CrudDao<DogBirthCertificate> {
	int listCount(DogBirthCertificate dogBirthCertificate);

	void review(DogBirthCertificate dogBirthCertificate);

	/**
	 * @description: 根据父母犬配犬证明号进行查询
	 * @author: laiguanglong
	 * @date: 2016年8月16日 下午5:41:58
	 */
	List<DogBirthCertificate> findByFmdogBreedCertifiedCode(String fmdogBreedCertifiedCode);

	DogBirthCertificate findByFmdogBreedCertifiedCodeNoDate(String fmdogBreedCertifiedCode);

	/**
	 * 根据配种证明查询一条出生纸信息
	 *
	 * @param fmdogBreedCertifiedCode
	 * @return
	 */
	DogBirthCertificate getfindByFmdogBreedCertifiedCode(String fmdogBreedCertifiedCode);

	long countByFmdogBreedCertifiedCode(String fmdogBreedCertifiedCode);

	/**
	 * @Description：对新生犬登记信息进行处理后，维护对应出生证明的血统证书号
	 * @author: zhuoHeng
	 * @version: 2016年8月10日 上午11:33:07
	 */
	public void createPedigreeCertified(@Param("pedigreeCertified") String pedigreeCertified,
			@Param("birthCode") String birthCode);

	/**
	 * @description: 获取随机犬名
	 * @author: laiguanglong
	 * @date: 2016年8月25日 上午10:09:13
	 */
	List<DogName> getDogNames(@Param("maleNumber") Integer maleNumber, @Param("femaleNumber") Integer femaleNumber);

	/**
	 * @description: TODO
	 * @author: laiguanglong
	 * @date: 2016年8月31日 下午8:15:52
	 */
	void updatePrintType(DogBirthCertificate dogBirthCertificate);

	void updateClassPrintStatus(DogBirthCertificate dogBirthCertificate);

	/**
	 * @Description：根据出生纸编号查询出生纸信息
	 * @author: zhuoHeng
	 * @version: 2016年10月24日 下午11:11:34
	 */
	DogBirthCertificate getByBirthCerRegCode(String birthCerRegCode);

	DogBirthCertificate getByPedigreeCertified(@Param("pedigreeCertified") String pedigreeCertified);

	DogBirthCertificate getByCabPassport(@Param("cabPassport") String cabPassport);

	/**
	 * 根据出生纸编号和识别码查询
	 *
	 * @Author chaixueteng
	 * @2016年10月12日上午10:44:43
	 */
	DogBirthCertificate getByBirthCodeAndSnCode(@Param("birthCerRegCode") String birthCerRegCode,
			@Param("snCode") String snCode);

	DogBirthCertificate findByBirthCodeAndSnCode(@Param("birthCerRegCode") String birthCerRegCode,
			@Param("snCode") String snCode);

	/**
	 * 根据芯片号查询
	 *
	 * @Author chaixueteng
	 * @2016年10月12日下午4:00:10 宠爱护照调用此接口 by chy 2018年4月18日下午7:00:10
	 */
	DogBirthCertificate getByIdentificationFlag(@Param("identificationFlag") String identificationFlag);

	/**
	 * 医院新生犬管理
	 *
	 * @Author chaixueteng
	 * @2016年10月13日下午1:57:29
	 */
	List<DogBirthCertificate> findHospitalList(DogBirthCertificate dogBirthCertificate);

	/**
	 * 医院新生犬管理
	 *
	 * @Author chaixueteng
	 * @2016年10月13日下午1:57:29
	 */
	List<DogBirthCertificate> findOldHospitalList(DogBirthCertificate dogBirthCertificate);

	/**
	 * @Description：根据出生纸编号对芯片号进行更改
	 * @author: zhuoHeng
	 * @version: 2016年10月17日 下午2:28:31
	 */
	void updateDogChip(DogBirthCertificate dogBirthCertificate);

	/**
	 * @Description：根据血统证书号对芯片号进行更改
	 * @author: zhuoHeng
	 * @version: 2016年10月17日 下午2:55:40
	 */
	void updateDogChipByPed(DogBirthCertificate dogBirthCertificate);

	/**
	 * 俱乐部新生犬管理
	 *
	 * @Author chaixueteng
	 * @2016年10月18日下午1:49:06
	 */
	List<DogBirthCertificate> findClubList(DogBirthCertificate dogBirthCertificate);

	/**
	 * @Description：根据出生证明编号修改出生纸正式犬主信息
	 * @author: zhuoHeng
	 * @version: 2016年10月24日 下午8:43:56
	 */
	void updateDogOwner(@Param("birthCode") String birthCode, @Param("dogOwenr") String dogOwenr,
			@Param("hidDogOwenrName") String hidDogOwenrName);

	/**
	 * @Description：根据出生证明编号修改出生纸临时犬主信息
	 * @author: zhuoHeng
	 * @version: 2016年10月24日 下午11:06:15
	 */
	void updateTempDogOwner(@Param("birthCode") String birthCode, @Param("dogOwenr") String dogOwenr,
			@Param("hidDogOwenrName") String hidDogOwenrName);

	/**
	 * @Descriion：根据出生证明编号修改出生纸临时犬主信息和俱乐部信息
	 * @author: zhangjunwu
	 * @version: 2020年04月23日 下午04:06:15
	 */
	void updateTempDogOwnerAndAddUser(@Param("birthCode") String birthCode, @Param("dogOwenr") String dogOwenr,
			@Param("hidDogOwenrName") String hidDogOwenrName, @Param("addUser") String addUser);

	/**
	 * @description: 根据时间查询未审核记录
	 * @author: laiguanglong
	 * @date: 2017/2/8 12:05
	 */
	List<String> findUnReviewByPayDate(@Param("date") Date date);

	/**
	 * @description: 根据配种证明编号查询一条出生纸记录
	 * @author: laiguanglong
	 * @date: 2017/2/8 15:14
	 */
	DogBirthCertificate getOneByFmdogBreedCertifiedCode(
			@Param("fmdogBreedCertifiedCode") String fmdogBreedCertifiedCode);

	/**
	 * 根据繁殖人和核算日期 查询年度申请出生纸数量
	 *
	 * @param oneYearAge        //核算日期一年前
	 * @param calculationDate   //核算日期
	 * @param breederMemberCode //繁殖人会员号
	 * @Author chaixueteng
	 * @2017年2月13日下午4:48:40
	 */
	List findBirthByBreeder(@Param("breederMemberCode") String breederMemberCode,
			@Param("calculationDate") Date calculationDate, @Param("oneYearAge") Date oneYearAge);

	// 根据繁殖人会员号查询申请出生纸记录数
	int countByBreederMemberCodeCurrentYear(@Param("memberCode") String memberCode);

	/**
	 * 根据芯片号和出生纸号查询
	 *
	 * @param birthCode
	 * @param chipCode
	 * @return
	 */
	DogBirthCertificate getByBirthCodeAndChipCode(@Param("birthCerRegCode") String birthCode,
			@Param("identificationFlag") String chipCode);

	/**
	 * 俱乐部旧出生纸状态
	 *
	 * @param dogBirthCertificate
	 * @return
	 */
	List<DogBirthCertificate> findOldClubList(DogBirthCertificate dogBirthCertificate);

	/**
	 * @description: 获取出生纸打印日期
	 * @author: laiguanglong
	 * @date: 2017/6/9 16:40
	 */
	String getPrintDate(@Param("runningNumber") String runningNumber);

	/**
	 * @description: 根据父犬血统证书号查询子代不同性别的数量
	 * @author: laiguanglong
	 * @date: 2017/10/11 16:35
	 */
	@MapKey("dogGender")
	HashMap<String, Map<String, Object>> getChildGenderCountMapByFdogPedigreeCertified(
			@Param("fdogPedigreeCertified") String fdogPedigreeCertified);

	/**
	 * @description: 根据配种证明号和流水号查询一批次的出生纸
	 * @author: laiguanglong
	 * @date: 2017/11/30 15:31
	 */
	List<DogBirthCertificate> findByFmdogBreedCertifiedCodeAndRunningNumber(
			@Param("fmdogBreedCertifiedCode") String fmdogBreedCertifiedCode,
			@Param("runningNumber") String runningNumber);

	// 查询会员名下参加过赛事的犬
	List<DogBirthCertificate> getCanApplyDogBirthCertificateList(@Param("memberCode") String memberCode,
			@Param("pageNo") Integer pageNo, @Param("pageSize") Integer pageSize);

	// 查询会员名下参加过赛事的犬数量
	long getCanApplyDogBirthCertificateCount(@Param("memberCode") String memberCode);

	// 查询会员名下可以申请幼犬的犬
	List<DogBirthCertificate> getCanApplyPupList(@Param("memberCode") String memberCode,
			@Param("dogBreed") String dogBreed, @Param("gender") String gender, @Param("order") String order,
			@Param("pageNo") Integer pageNo, @Param("pageSize") Integer pageSize);

	// 查询会员名下可以申请幼犬的犬数量
	long getCanApplyPupCount(@Param("memberCode") String memberCode, @Param("dogBreed") String dogBreed,
			@Param("gender") String gender, @Param("order") String order);

	// 查询会员名下可以申请幼犬的出生纸的犬种
	List<Map<String, String>> getCanApplyPupDogBreed(@Param("memberCode") String memberCode);

	// 查询会员名下申请出生纸的数量
	int getKennelBirth(@Param("startDate") Date startDate, @Param("endDate") Date endDate,
			@Param("memberCode") String memberCode);

	List<DogBirthCertificate> getByIdentificationFlagList(@Param("identificationFlag") String identificationFlag);

	/***
	 *
	 * 更新 上架 下架状态
	 *
	 * @param mcode 当前登录用户code
	 * @param state 更改状态
	 * @param id    dog_activation表id
	 * @return 是否更新成功
	 */
	int updateState(@Param("mcode") String mcode, @Param("state") String state, @Param("id") String id);

	/**
	 * @param dogBreed     种类
	 * @param stateInt     状态
	 * @param dogGenderInt 性别
	 * @param memberCode
	 * @param type
	 * @param searchKey
	 * @param pageNo
	 * @param pageSize
	 * @param date
	 * @return
	 */
	List<DogBirthCertificate> getList1(@Param("dogBreed") String dogBreed, @Param("stateInt") Integer stateInt,
			@Param("dogGenderInt") Integer dogGenderInt, @Param("memberCode") String memberCode,
			@Param("type") String type, @Param("searchKey") String searchKey, @Param("pageNo") Integer pageNo,
			@Param("pageSize") Integer pageSize, @Param("date") Date date);

	long getList1Count(@Param("dogBreed") String dogBreed, @Param("stateInt") Integer stateInt,
			@Param("dogGenderInt") Integer dogGenderInt, @Param("memberCode") String memberCode,
			@Param("type") String type, @Param("searchKey") String searchKey, @Param("date") Date date);

	// 保存已售犬只
	int saveSoldDogBirthCertificate(DogBirthCertificate dogBirthCertificate);

	// 更新繁殖状态
	int updateDogBirthCertificateBusinessBan(DogBirthCertificate dogBirthCertificate);

	// 根据配种证明编号删除整窝数据
	void updateALLByFmdogBreedCertifiedCode(@Param("fmdogBreedCertifiedCode") String fmdogBreedCertifiedCode,
			@Param("remarks") String remarks);

	void updateActivationStates(@Param("birthCode") String birthCode, @Param("activitionState") String activitionState);

	List<DogBirthCertificate> dogAllNestList(DogBirthCertificate dogBirthCertificate);

	/**
	 * 根据会员号查询主营犬种 @Description：
	 *
	 * @author: yuanshuai
	 * @date: 2019/7/16 16:41
	 */
	String getMainBreedByMemberCode(@Param("memberCode") String memberCode);

	void refundDogBirthCertificate(@Param("vo") DogBirthCertificate dogBirthCertificate, @Param("ids") Set<String> ids);

	void refundDogBirthCertificateForAll(@Param("vo") DogBirthCertificate dogBirthCertificate,
			@Param("ids") Set<String> ids);

	List<DogBirthCertificate> getTransferList(@Param("birthCerRegCode") String birthCerRegCode,
			@Param("transferCode") String transferCode, @Param("source") String source, @Param("pageNo") Integer pageNo,
			@Param("pageSize") Integer pageSize);

	Long getTransferListCount(@Param("birthCerRegCode") String birthCerRegCode,
			@Param("transferCode") String transferCode, @Param("source") String source);

	void updateEcertFlag(@Param("id") String id);

	void updateAddUser(@Param("birthCode") String birthCode, @Param("addUser") String addUser);

	DogBirthCertificate getParentsByBirthCerRegCode(@Param("birthCerRegCode") String birthCerRegCode);
	
	void refundDogBirthCertificateDelAddUser(@Param("id")String id);

	/**
	 * @Description：根据血统证书号查询子犬信息
	 */
	List<DogBirthCertificate> getChildDogInfoByPedigreeCertified(String pedigreeCertified);

	DogBirthCertificate getDogBirthCertificateByBirthCode(@Param("birthCerRegCode") String birthCerRegCode);
}