package com.cku.oa.contest.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.cku.oa.contest.entity.Language;
import com.cku.oa.contest.service.LanguageService;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.cku.oa.contest.entity.ContestGradeDisqualified;
import com.cku.oa.contest.service.ContestGradeDisqualifiedService;

/**
 * 犬展失格评价Controller
 * @author yuanshuai
 * @version 2020-10-12
 */
@Controller
@RequestMapping(value = "${adminPath}/contest/contestGradeDisqualified")
public class ContestGradeDisqualifiedController extends BaseController {

	@Autowired
	private ContestGradeDisqualifiedService contestGradeDisqualifiedService;
	@Autowired
	private LanguageService languageService;

	@ModelAttribute
	public ContestGradeDisqualified get(@RequestParam(required=false) String id) {
		ContestGradeDisqualified entity = null;
		if (StringUtils.isNotBlank(id)){
			entity = contestGradeDisqualifiedService.get(id);
		}
		if (entity == null){
			entity = new ContestGradeDisqualified();
		}
		return entity;
	}
	
	@RequiresPermissions("contest:contestGradeDisqualified:view")
	@RequestMapping(value = {"list", ""})
	public String list(ContestGradeDisqualified contestGradeDisqualified, HttpServletRequest request, HttpServletResponse response, Model model) {
		Page<ContestGradeDisqualified> page = contestGradeDisqualifiedService.findPage(new Page<>(request, response), contestGradeDisqualified);
		model.addAttribute("page", page);
		model.addAttribute("languageList", languageService.findList(new Language()));
		return "oa/contest/contestGradeDisqualifiedList";
	}

	@RequiresPermissions("contest:contestGradeDisqualified:view")
	@RequestMapping(value = "form")
	public String form(ContestGradeDisqualified contestGradeDisqualified, Model model) {
		model.addAttribute("contestGradeDisqualified", contestGradeDisqualified);
		model.addAttribute("languageList", languageService.findList(new Language()));
		return "oa/contest/contestGradeDisqualifiedForm";
	}

	@RequiresPermissions("contest:contestGradeDisqualified:edit")
	@RequestMapping(value = "save")
	public String save(ContestGradeDisqualified contestGradeDisqualified, Model model, RedirectAttributes redirectAttributes) {
		if (!beanValidator(model, contestGradeDisqualified)){
			return form(contestGradeDisqualified, model);
		}
		contestGradeDisqualifiedService.save(contestGradeDisqualified);
		addMessage(redirectAttributes, "保存犬展失格评价成功");
		return "redirect:"+Global.getAdminPath()+"/contest/contestGradeDisqualified/?repage";
	}
	
	@RequiresPermissions("contest:contestGradeDisqualified:del")
	@RequestMapping(value = "delete")
	public String delete(ContestGradeDisqualified contestGradeDisqualified, RedirectAttributes redirectAttributes) {
		contestGradeDisqualifiedService.delete(contestGradeDisqualified);
		addMessage(redirectAttributes, "删除犬展失格评价成功");
		return "redirect:"+Global.getAdminPath()+"/contest/contestGradeDisqualified/?repage";
	}

}