package com.cku.oa.banner.service;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.cku.oa.banner.dao.AppSplashAdsDao;
import com.cku.oa.banner.entity.AppSplashAds;
import com.cku.restful.v1.banner.vo.RestSplashAdsResponse;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;

/**
 * 开屏广告配置Service
 * @author xx
 * @version 2023-08-07
 */
@Service
@Transactional(readOnly = true)
public class AppSplashAdsService extends CrudService<AppSplashAdsDao, AppSplashAds> {

	public AppSplashAds get(String id) {
		return super.get(id);
	}
	
	public List<AppSplashAds> findList(AppSplashAds appSplashAds) {
		return super.findList(appSplashAds);
	}
	
	public Page<AppSplashAds> findPage(Page<AppSplashAds> page, AppSplashAds appSplashAds) {
		return super.findPage(page, appSplashAds);
	}
	
	@Transactional(readOnly = false)
	public void save(AppSplashAds appSplashAds) {
		super.save(appSplashAds);
	}
	
	@Transactional(readOnly = false)
	public void delete(AppSplashAds appSplashAds) {
		super.delete(appSplashAds);
	}
	
	@Transactional(readOnly = false)
	public RestSplashAdsResponse getOne() {
		List<AppSplashAds>  list = dao.findFrontList(1);
		if(CollectionUtils.isEmpty(list)) {
			return null;
		}
		AppSplashAds appSplashAds = list.get(0);
		RestSplashAdsResponse re = new RestSplashAdsResponse();
		BeanUtils.copyProperties(appSplashAds, re);
		return re;
	}
	
	@Transactional(readOnly = false)
	public List<RestSplashAdsResponse> getList(String num) {
		List<RestSplashAdsResponse> reList = new ArrayList<>();
		List<AppSplashAds>  list = dao.findFrontList(Integer.valueOf(num));
		if(CollectionUtils.isEmpty(list)) {
			return reList;
		}
		list.forEach(a->{
			RestSplashAdsResponse re = new RestSplashAdsResponse();
			BeanUtils.copyProperties(a, re);
			reList.add(re);
		});
		return reList;
	}
	
	
}