/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.appreciation.entity;

import org.hibernate.validator.constraints.Length;

import com.thinkgem.jeesite.common.persistence.DataEntity;

/**
 * 鉴赏课Entity
 * @author xx
 * @version 2022-02-16
 */
public class AppreciationCoursesCoursewareRef extends DataEntity<AppreciationCoursesCoursewareRef> {
	
	private static final long serialVersionUID = 1L;
	private String courseId;		// 课程ID
	private String coursewareId;		// 课件ID
	
	public AppreciationCoursesCoursewareRef() {
		super();
	}

	public AppreciationCoursesCoursewareRef(String id){
		super(id);
	}

	@Length(min=0, max=50, message="课程ID长度必须介于 0 和 50 之间")
	public String getCourseId() {
		return courseId;
	}

	public void setCourseId(String courseId) {
		this.courseId = courseId;
	}
	
	@Length(min=0, max=50, message="课件ID长度必须介于 0 和 50 之间")
	public String getCoursewareId() {
		return coursewareId;
	}

	public void setCoursewareId(String coursewareId) {
		this.coursewareId = coursewareId;
	}
	
}