package com.cku.oa.activity.service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.cku.oa.activity.dao.SysMemberActivityRecordDao;
import com.cku.oa.activity.entity.SysMemberActivityRecord;
import com.cku.oa.activity.vo.MemberStartDateEnum;
import com.cku.oa.activity.vo.NewYearActivitiesEnum;
import com.cku.oa.finance.dao.PaymentOrderDetailDao;
import com.cku.oa.finance.entity.PaymentChargingItem;
import com.cku.oa.kennel.entity.Kennel;
import com.cku.oa.sys.entity.user.Member;
import com.cku.oa.sys.vo.MemberRenewalRecordVO;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import com.thinkgem.jeesite.common.utils.IdGen;
import com.thinkgem.jeesite.modules.sys.entity.User;

/**
 * 会员续费参与活动记录Service
 * 
 * @author Sunny
 * @version 2019-12-05
 */
@Service
@Transactional(readOnly = true)
public class SysMemberActivityRecordService extends CrudService<SysMemberActivityRecordDao, SysMemberActivityRecord> {

	@Autowired
	private PaymentOrderDetailDao paymentOrderDetailDao;

	public SysMemberActivityRecord get(String id) {
		return super.get(id);
	}

	public SysMemberActivityRecord getOneEntity(SysMemberActivityRecord sysMemberActivityRecord) {
		return dao.getOneEntity(sysMemberActivityRecord);
	}

	public List<SysMemberActivityRecord> findList(SysMemberActivityRecord sysMemberActivityRecord) {
		return super.findList(sysMemberActivityRecord);
	}

	public int saveRecord(SysMemberActivityRecord sysMemberActivityRecord) {
		return dao.saveRecord(sysMemberActivityRecord);
	}

	public Page<SysMemberActivityRecord> findPage(Page<SysMemberActivityRecord> page,
			SysMemberActivityRecord sysMemberActivityRecord) {
		return super.findPage(page, sysMemberActivityRecord);
	}

	@Transactional(readOnly = false)
	public void save(SysMemberActivityRecord sysMemberActivityRecord) {
		super.save(sysMemberActivityRecord);
	}

	@Transactional(readOnly = false)
	public void insert(SysMemberActivityRecord sysMemberActivityRecord) {
		dao.insert(sysMemberActivityRecord);
	}

	@Transactional(readOnly = false)
	public void delete(SysMemberActivityRecord sysMemberActivityRecord) {
		super.delete(sysMemberActivityRecord);
	}

	public List<MemberRenewalRecordVO> getListByMemberId(Member member) {
		List<MemberRenewalRecordVO> list = new ArrayList<>();
		// 查询会员第一次注册是不是普卡会员
		SysMemberActivityRecord pk = dao.getOneByActivityTypeAndmemberCode("999100900100", member.getMemberCode());

		// 查询该会员已经缴费的订单
		List<SysMemberActivityRecord> list2 = dao.getListByMemberId(member.getId());
		for (int i = 0; i < list2.size(); i++) {
			MemberRenewalRecordVO vo = new MemberRenewalRecordVO();
			SysMemberActivityRecord record = list2.get(i);
			if (pk != null) {
				vo.setNum(list2.size() - i + 1);
			} else {
				vo.setNum(list2.size() - i);
			}
			vo.setPaymentTime(record.getPaymentTime());
			vo.setPrice(record.getTotalPrice());// 查询该收费项的价格 和订单价格取一
			if (StringUtils.isNotBlank(record.getActivityType())) {
				// 先对13 14位的ActivityType做解析
				if (record.getActivityType().length() >= 13) {
					String beforeMemberType = null;// 续费前会员类型
					String type = null;// 0是续费1是升级
					String isOverdue = null;// 1是未过期2已过期
					String afterMemberType = null;// 续费后会员类型
					vo.setMemberEndDate(record.getNewMemberEndDate());
					if (MemberStartDateEnum.get(record.getActivityType()) != null) {
						vo.setMemberStartDate(record.getMemberEndDate());
					} else if ("99910109011010".equals(record.getActivityType())
							&& new Date().before(record.getMemberEndDate())) {
						vo.setMemberStartDate(record.getMemberEndDate());
					} else {
						vo.setMemberStartDate(record.getCreateDate());
					}
					if (record.getActivityType().length() == 13) {
						vo.setType(pk != null ? "升级" : "注册");
						beforeMemberType = record.getActivityType().substring(3, 6);// 续费前会员类型 4-6位
						type = record.getActivityType().substring(7, 8);// 0是续费1是升级 8位
						isOverdue = record.getActivityType().substring(8, 9);// 1是未过期2已过期 9位
						afterMemberType = record.getActivityType().substring(9, 13);// 续费后会员类型 10-13位
					} else if (record.getActivityType().length() == 14) {
						beforeMemberType = record.getActivityType().substring(3, 7);// 续费前会员类型 4-7位
						type = record.getActivityType().substring(8, 9);// 0是续费1是升级 9位
						isOverdue = record.getActivityType().substring(9, 10);// 1是未过期2已过期 10位
						afterMemberType = record.getActivityType().substring(10, 14);// 续费后会员类型 11-14位
						vo.setType("1".equals(type) ? "升级" : "续费");
					}
					if ("100".equals(afterMemberType))
						vo.setMemberType("爱宠会员普卡");
					else if ("1010".equals(afterMemberType))
						vo.setMemberType("爱宠会员银卡");
					else if ("1020".equals(afterMemberType))
						vo.setMemberType("爱宠会员金卡");
					else if ("2030".equals(afterMemberType))
						vo.setMemberType("繁专员铂金卡");
					else if ("2040".equals(afterMemberType))
						vo.setMemberType("繁专员紫金卡");
				} else {
					// 解析新年活动的相关记录
					NewYearActivitiesEnum e = NewYearActivitiesEnum.get(record.getActivityType());
					if (e != null) {
						vo.setMemberStartDate(
								"2".equals(e.getIsOverdue()) ? record.getCreateDate() : record.getMemberEndDate());
						vo.setType(e.getType());
						vo.setMemberType(e.getMemberType());
					}
					vo.setMemberEndDate(record.getNewMemberEndDate());
				}
			} else {
				// 没有记录日志的订单只能拉出收费项名称
				if (StringUtils.isNotBlank(record.getOrderCode())) {
					List<PaymentChargingItem> list3 = paymentOrderDetailDao
							.findChargingItemsByOrderCode(record.getOrderCode());
					String memberType = "";
					for (PaymentChargingItem item : list3) {
						memberType = memberType + ("".equals(memberType) ? "" : "|") + item.getName();

					}
					vo.setMemberType(memberType);
					vo.setType(memberType.contains("注册") ? "注册" : memberType.contains("升级") ? "升级" : "续费");
				}

			}
			list.add(vo);

		}
		if (pk != null) {
			MemberRenewalRecordVO vo = new MemberRenewalRecordVO();
			vo.setNum(1);
			vo.setPaymentTime(pk.getParticipationTime());
			vo.setPrice("0.00");
			vo.setMemberStartDate(null);
			vo.setType("注册");
			vo.setMemberType("爱宠会员普卡");
			vo.setMemberEndDate(null);
			list.add(vo);
		}
		return list;
	}
	
	/**
	 * 后台直接修改会员，记录会员信息变动
	 * 
	 * @param oldMember
	 * @param newMember
	 * @param createBy
	 */
	@Transactional(readOnly = false)
	public void saveMemberRecordWoOrder(Member oldMember, Member newMember, User createBy,String originalMemberCode) {
		if ( newMember == null || createBy == null) {
			return;
		}
		if(oldMember == null ) {
			oldMember = new Member();
		}
		// 关注信息不改动，不必记录
		if (!StringUtils.equals(oldMember.getMemberCode(), newMember.getMemberCode())
				|| !compareDate(oldMember.getGroomerEndDate(), newMember.getGroomerEndDate())
				|| !StringUtils.equals(oldMember.getGroomerType(), newMember.getGroomerType())
				|| !compareDate(oldMember.getMemberEndDate(), newMember.getMemberEndDate())
				|| !StringUtils.equals(oldMember.getMemberType(), newMember.getMemberType())
				|| !StringUtils.equals(oldMember.getMemberCardType(), newMember.getMemberCardType())
				|| !compareKennel(oldMember.getKennel(), newMember.getKennel())) {

			SysMemberActivityRecord record = new SysMemberActivityRecord();
			record.setId(IdGen.uuid());
			record.setGroomerEndDate(oldMember.getGroomerEndDate());
			record.setGroomerType(oldMember.getGroomerType());
			record.setMemberEndDate(oldMember.getMemberEndDate());
			record.setMemberType(oldMember.getMemberType());
			record.setMemeberCode(newMember.getMemberCode());
			record.setMemeberName(newMember.getName());
			if (oldMember.getKennel() != null) {
				record.setKennelEndDate(oldMember.getKennel().getEndTime());
				record.setKennelType(oldMember.getKennel().getType());
			}
			record.setCreateDate(new Date());
			record.setGiveGift("0");
			record.setGiveMonth("0");
			record.setParticipationTime(new Date());
			record.setRecordType("2");
			record.setMemberCardType(oldMember.getMemberCardType());
			record.setCreateBy(createBy);
			record.setNewMemberType(newMember.getMemberType());
			record.setNewMemberEndDate(newMember.getMemberEndDate());
			record.setNewMemberCardType(newMember.getMemberCardType());
			if(newMember.getKennel() != null) {
				record.setNewKennelEndDate(newMember.getKennel().getEndTime());
				record.setKennelCode(newMember.getKennel().getKennelCode());
				record.setKennelName(newMember.getKennel().getName());
				record.setNewKennelType(newMember.getKennel().getType());
			}
			record.setNewGroomerEndDate(newMember.getGroomerEndDate());
			record.setNewGroomerType(newMember.getGroomerType());
			record.setOriginalMemberCode(originalMemberCode);
			dao.insert(record);
		}
	}
	// 日期比较方法
		private boolean compareDate(Date first, Date second) {
			if (first == null && second == null) {
				return true;
			} else if (first == null && second != null) {
				return false;
			} else {
				return first.compareTo(second) == 0;
			}
		}
		
		private boolean compareKennel(Kennel first, Kennel second) {
			if ((first == null||StringUtils.isBlank(first.getName())) 
					&& (second == null||StringUtils.isBlank(second.getName()))) {
				return true;
			} else if ((first == null||StringUtils.isBlank(first.getName()))  && second != null) {
				return false;
			} else if (first != null &&  (second == null||StringUtils.isBlank(second.getName()))) {
				return false;
			} else if (first != null && second != null) {
				if (!StringUtils.equals(first.getMemberCode(), second.getMemberCode())
						|| !StringUtils.equals(first.getType(), second.getType())
						|| !compareDate(first.getEndTime(), second.getEndTime())) {
					return false;
				} else {
					return true;
				}
			}
			return false;
		}
		
	

}