<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>出生证明管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			//$("#name").focus();
			$("#inputForm").validate({
				submitHandler: function(form){
					loading('正在提交，请稍等...');
					form.submit();
				},
				errorContainer: "#messageBox",
				errorPlacement: function(error, element) {
					$("#messageBox").text("输入有误，请先更正。");
					if (element.is(":checkbox")||element.is(":radio")||element.parent().is(".input-append")){
						error.appendTo(element.parent().parent());
					} else {
						error.insertAfter(element);
					}
				}
			});
		});
	</script>
	<link rel="stylesheet" href="${ctxStatic }/modules/common/two-column.css"/>
</head>
<body>
	<ul class="nav nav-tabs">
		<li><a href="${ctxDc}/dogBirthCertificate">出生证明列表</a></li>
		<li class="active"><a href="${ctxDc}/dogBirthCertificate/form?id=${fns:escapeHtml(dogBirthCertificate.id)}">出生证明查看</a></li>
	</ul><br/>
	<form:form id="inputForm" modelAttribute="dogBirthCertificate" action="${ctxDc}/birthcertificate/dogBirthCertificate/edit" method="post" class="form-horizontal">
		<form:hidden path="id"/>
		<sys:message content="${message}"/>		
		<div class="control-group">
			<label class="control-label">出生纸编号：</label>
			<div class="controls">
				<form:input path="birthCerRegCode" disabled="true" htmlEscape="false" maxlength="255" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">血统证书号：</label>
			<div class="controls">
				${fns:escapeHtml(dogBirthCertificate.pedigreeCertified)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">英文犬名：</label>
			<div class="controls">
				<form:input path="dogEnName" disabled="true" htmlEscape="false" maxlength="255" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">犬只性别：</label>
			<div class="controls">
				<form:radiobuttons path="dogGender" disabled="true" items="${fns:getDictList('dog_gender')}" itemLabel="label" itemValue="value" htmlEscape="false" class="required"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">犬主姓名：</label>
			<div class="controls">
				<form:input path="dogOwenr" disabled="true" htmlEscape="false" maxlength="50" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">犬主会员号：</label>
			<div class="controls">
				<form:input path="memberCode" disabled="true" htmlEscape="false" maxlength="50" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">新犬主姓名：</label>
			<div class="controls">
				<form:input path="tempUserName" readonly="true" htmlEscape="false" maxlength="50" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">新犬主会员号：</label>
			<div class="controls">
				<form:input path="tempMemberCode" readonly="true" htmlEscape="false" maxlength="50" class="input-xlarge isDigits"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">第二犬主：</label>
			<div class="controls">
				<form:input path="secondDogOwner" disabled="true" htmlEscape="false" maxlength="50" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">第二犬主会员号：</label>
			<div class="controls">
				<form:input path="secondOwnerMemberCode" disabled="true" htmlEscape="false" maxlength="50" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">出生日期：</label>
			<div class="controls">
				<input name="dogBirthday"  type="text" readonly="readonly" maxlength="20" class="input-medium Wdate "
					value="<fmt:formatDate value="${dogBirthCertificate.dogBirthday}" pattern="yyyy-MM-dd"/>"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">芯片号码：</label>
			<div class="controls">
				${fns:escapeHtml(dogBirthCertificate.identificationFlag)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">犬种：</label>
			<div class="controls">
				${fns:escapeHtml(dogBirthCertificate.dogBreed)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">颜色及标志：</label>
			<div class="controls">
                <form:select id="colorFlag" disabled="true" path="colorFlag" class="input-xlarge required">
                	<form:options items="${dogColorMarkList}" itemLabel="dogColorMarkCn" itemValue="dogColorMarkCode" htmlEscape="false"/>
                </form:select>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">DNA编号：</label>
			<div class="controls">
				<form:input path="dna" disabled="true" htmlEscape="false" maxlength="255" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">配种证明号：</label>
			<div class="controls">
				<form:input path="fmdogBreedCertifiedCode" disabled="true" htmlEscape="false" maxlength="100" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">繁育人：</label>
			<div class="controls">
				<form:input path="breeder" disabled="true" htmlEscape="false" maxlength="50" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">业务禁止：</label>
			<div class="controls">
				<form:select path="businessBan" disabled="true" class="input-xlarge ">
					<form:option value="" label=""/>
					<form:options items="${fns:getDictList('business_ban')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">父犬证书号：</label>
			<div class="controls">
				<form:input path="fdogPedigreeCertified" disabled="true" htmlEscape="false" maxlength="100" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">母犬证书号：</label>
			<div class="controls">
				<form:input path="mdogPedigreeCertified" disabled="true" htmlEscape="false" maxlength="100" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">审核状态：</label>
			<div class="controls">
				<form:select path="reviewState" disabled="true" class="input-xlarge ">
					<form:option value="" label=""/>
					<form:options items="${fns:getDictList('dog_birth_certificate_review_state')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">审核的意见：</label>
			<div class="controls">
				<form:input path="reviewRemarks" disabled="true" htmlEscape="false" maxlength="255" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">添加日期：</label>
			<div class="controls">
				<fmt:formatDate value="${dogBirthCertificate.createDate}" pattern="yyyy-MM-dd HH:mm:ss"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">备注信息：</label>
			<div class="controls">
				<form:textarea path="remarks" disabled="true" htmlEscape="false" rows="4" maxlength="255" class="input-xxlarge "/>
			</div>
		</div>
		<div style = "clear:both;"/>
		<div class="form-actions">
			<input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
		</div>
	</form:form>
</body>
</html>