<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
    <title>犬舍名称变更信息管理</title>
    <meta name="decorator" content="default"/>
    <script type="text/javascript">
        $(document).ready(function() {
        	closeLoading();
        });
        function auditForm(id){
			top.layer.open({
				type: 2,
				title: ['犬舍名称变更审核', 'font-size:18px;text-align: center;'],
				shadeClose: false,
				shade: [0.8, '#393D49'],
				maxmin: false, //开启最大化最小化按钮
				area: ['800px', '600px'],
				content: "${ctx}/kennel/kennelRename/auditForm?id="+id,
				end:function(){
					alert(top.isYes);
					if(top.isYes){
						top.layer.closeAll();
						parent.location.reload();
					}
				}
			});
		}
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
    </script>
</head>
    <table id="contentTable" class="table table-striped table-bordered table-condensed">
        <thead>
            <tr>
				<th>会员号</th>
				<th>原犬舍中文名</th>
				<th>原犬舍英文名</th>
				<th>新犬舍中文名</th>
				<th>新犬舍英文名</th>
				<th>订单状态</th>
				<th>审核状态</th>
            </tr>
        </thead>
        <tbody>
        <c:forEach items="${page.list}" var="kennelRename">
            <tr>
                <td>
                    ${fns:escapeHtml(kennelRename.memberCode)}
                </td>
                <td>
                	${fns:escapeHtml(kennelRename.originalNameCn)}               
                </td>
                <td>
                    ${fns:escapeHtml(kennelRename.originalNameEn)}
                </td>
                <td>
                    ${fns:escapeHtml(kennelRename.newNameCn)}
                </td>
                <td>
                    ${fns:escapeHtml(kennelRename.newNameEn)}
                </td>
                <td>
					<c:if test="${'1' eq kennelRename.paymentState}">
						<font color="red">${fns:getDictLabel(kennelRename.paymentState, 'user_payment_state', '')}</font>
					</c:if>
					<c:if test="${'2' eq kennelRename.paymentState}">
						<font color="green">${fns:getDictLabel(kennelRename.paymentState, 'user_payment_state', '')}</font>
					</c:if>
				</td>
				<td>
				<c:choose>
					<c:when test="${'1' eq kennelRename.reviewState||kennelRename.businessRefundState}">
						${fns:getDictLabel(kennelRename.reviewState, 'review_state', '')}
					</c:when>
					<c:when test="${'0' eq kennelRename.reviewState}">
						<shiro:hasPermission name="kennel:kennelRename:audit">
							<a href="#" onclick="auditForm('${fns:escapeHtml(kennelRename.id)}')"><font color="red">${fns:getDictLabel(kennelRename.reviewState, 'review_state', '')}</font></a>
						</shiro:hasPermission>
						<shiro:lacksPermission name="kennel:kennelRename:audit">
							<font color="red">${fns:getDictLabel(kennelRename.reviewState, 'review_state', '')}</font>
						</shiro:lacksPermission>
					</c:when>
					<c:when test="${'2' eq kennelRename.reviewState}">
						<a title="${fns:escapeHtml(kennelRename.reviewRemarks)}">${fns:getDictLabel(kennelRename.reviewState, 'review_state', '')}</a>
					</c:when>
					</c:choose>
				</td>
            </tr>
        </c:forEach>
        </tbody>
    </table>
</body>
</html>