<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>牵犬师积分榜管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
		}
		function uploadHandlerScoreRanking(tableType,year,month,quarter){
			 parent.layer.open({
				type: 2,
				title: ['上传榜单数据', 'font-size:18px;text-align: center;'],
				shadeClose: false,
				shade: [0.8, '#393D49'],
				maxmin: false, //开启最大化最小化按钮
				area: ['600px', '400px'],
				content: ctx+"/handler/handlerScoreRanking/uploadForm?tableType="+tableType+"&year="+year+"&month="+month+"&quarter="+quarter,
				end: function(){
					if(parent.isYes){
						var mainF = parent.$("#mainFrame");
						mainF.contents().find("#searchForm").submit();
					};
				}
			}); 
		};
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/handler/handlerScoreRanking/">牵犬师积分榜列表</a></li>
	</ul>
	<form:form id="searchForm" modelAttribute="handlerScoreRanking" action="${ctx}/handler/handlerScoreRanking/" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>榜单类型：</label>
				<form:select path="tableType" class="input-medium">
					<form:option value="" label="全部"/>
					<form:options items="${fns:getDictList('table_type')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
			<li><label>年份：</label>
				<form:select path="year" class="input-medium">
					<form:option value="" label="全部"/>
					<c:forEach items="${yearList}" var="year">
						<form:option value="${year}" label="${year}"/>
					</c:forEach>
				</form:select>
			</li>
			<li><label>月份：</label>
				<form:select path="month" class="input-medium">
					<form:option value="" label="全部"/>
					<c:forEach items="${monthList}" var="month">
						<form:option value="${month}" label="${month}月"/>
					</c:forEach>
				</form:select>
			</li>
			<li><label>季度：</label>
				<form:select path="quarter" class="input-medium">
					<form:option value="" label="全部"/>
					<form:options items="${fns:getDictList('quarter')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<li class="btns">
				<shiro:hasPermission name="handler:handlerScoreRanking:edit">
					<input id="upload" class="btn btn-primary" type="button"   onclick="uploadHandlerScoreRanking('','','','')" value="上传榜单数据"/>
				</shiro:hasPermission>
			</li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>榜单类型</th>
				<th>年份</th>
				<th>月份</th>
				<th>季度</th>
				<th>更新时间</th>
				<shiro:hasPermission name="handler:handlerScoreRanking:edit"><th>操作</th></shiro:hasPermission>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="handlerScoreRanking">
			<tr>
				<td>
					${fns:getDictLabel(handlerScoreRanking.tableType, 'table_type', '')}
				</td>
				<td>
					${handlerScoreRanking.year}年
				</td>
				<td>
					<c:if test="${handlerScoreRanking.month == null}">
					--
					</c:if>
					<c:if test="${handlerScoreRanking.month != null}">
					${handlerScoreRanking.month}月
					</c:if>
				</td>
				<td>
					<c:if test="${handlerScoreRanking.quarter == null}">
					--
					</c:if>
					<c:if test="${handlerScoreRanking.quarter != null}">
					第${handlerScoreRanking.quarter}季度
					</c:if>
				</td>
				<td>
					<fmt:formatDate value="${handlerScoreRanking.updateDate}" pattern="yyyy-MM-dd HH:mm:ss"/>
				</td>
				<shiro:hasPermission name="handler:handlerScoreRanking:edit"><td>
    				<a href="${ctx}/handler/handlerScoreRanking/export?tableType=${handlerScoreRanking.tableType}&year=${handlerScoreRanking.year}&quarter=${handlerScoreRanking.quarter}&month=${handlerScoreRanking.month}">下载当前</a>
    				<a href=""
    					 onclick="uploadHandlerScoreRanking('${handlerScoreRanking.tableType}','${handlerScoreRanking.year}','${handlerScoreRanking.month}','${handlerScoreRanking.quarter}')">更新数据</a>
					<a href="${ctx}/handler/handlerScoreRanking/delete?tableType=${handlerScoreRanking.tableType}&year=${handlerScoreRanking.year}&quarter=${handlerScoreRanking.quarter}&month=${handlerScoreRanking.month}" onclick="return confirmx('确认要删除这组记录吗？', this.href)">删除</a>
				</td></shiro:hasPermission>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>