<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>活动管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
		

	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/groomer/groomerShow/">美容报名统计</a></li>
	</ul>
	<form:form id="searchForm" modelAttribute="groomerShow" action="${ctx}/groomer/groomerShow/getShowStatictices" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>日期：</label>
				<input name="beginDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
					value="<fmt:formatDate value="${groomerShow.beginDate}" pattern="yyyy-MM-dd"/>"
					onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/> - 
				<input name="endDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
					value="<fmt:formatDate value="${groomerShow.endDate}" pattern="yyyy-MM-dd"/>"
					onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<div class="search_one" style="text-align:right">
	<span style="font-size:24px; color:#900">总计：</span><strong>场次总数：</strong><span style="font-size:18px; color: #F00;">${allShows}</span> 次&nbsp;&nbsp;<strong>收入总数：</strong><span style="font-size:18px; color: #F00;">${allFee }</span>元&nbsp;&nbsp;<strong>报名人总数：</strong><span style="font-size:18px; color: #F00;">${allMemberNum }</span>人
	</div>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>赛事编号</th>
				<th>赛事名称</th>
				<th>赛事地点</th>
				<th>成绩</th>
				<th>参赛犬只</th>
				<th>本场报名总数</th>
				<th>本场报名费收入</th>
				<th>赛前退赛人数</th>
				<th>赛前请假人数</th>
				<th>本场退赛费合计</th>
				<th>实际金额</th>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="groomerShow">
			<tr>
				<td>
					${fns:escapeHtml(groomerShow.showCode)}
				</td>
				<td>
					${fns:escapeHtml(groomerShow.showName)}
				</td>
				<td>
					${fns:escapeHtml(groomerShow.showAddress)}
				</td>
				<td>
					<a href="/oa-web/oaManage/groomer/groomerRegister/grade?showCode=${groomerShow.showCode }">查看</a>
				</td>
				<td>
					${groomerShow.dogNum }
				</td>
				<td>
					${groomerShow.memberNum }
				</td>
				<td>
					${groomerShow.feeNum }
				</td>
				<td>
					${groomerShow.leaveNum }
				</td>
				<td>
					${groomerShow.cancel }
				</td>
				<td>
    				${groomerShow.cancelFeeNum }
				</td>
				<td>
					${groomerShow.allFeeNum }
				</td>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>