<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>活动电话报名</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			
		});
		
		
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/groomer/groomerShow/register">电话报名</a></li>
	</ul>
	<form:form id="searchForm" modelAttribute="groomerShow" action="${ctx}/groomer/groomerShow/register" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>活动类型：</label>
				<form:select path="showType" class="input-medium">
					<form:option value="" label="全部"/>
					<form:options items="${fns:getDictList('groomer_show_type')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
			<li><label>活动名称：</label>
				<form:input path="showName" htmlEscape="false" maxlength="255" class="input-medium"/>
			</li>
			<li><label>活动地点：</label>
				<form:input path="showAddress" htmlEscape="false" maxlength="255" class="input-medium"/>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>活动类型</th>
				<th>活动名称</th>
				<th>活动地点</th>
				<th>截止时间</th>
				<shiro:hasPermission name="groomer:groomerShow:register"><th>操作</th></shiro:hasPermission>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="groomerShow">
			<tr>	
				<td>
					${fns:getDictLabel(groomerShow.showType, 'groomer_show_type', '')}
				</td>
				<td>
					${fns:escapeHtml(groomerShow.showName)}
				</td>
				<td>
					${groomerShow.showAddress}
				</td>
				<td>
					<fmt:formatDate value="${groomerShow.registerEndTime}" pattern="yyyy-MM-dd HH:mm:ss"/>
				</td>
				<shiro:hasPermission name="groomer:groomerShow:register"><td>
    				<a href="${ctx}/groomer/groomerShow/registerPage?id=${groomerShow.id}" >报名</a>
				</td></shiro:hasPermission>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>