<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
    <title>犬主变更编辑</title>
    <meta name="decorator" content="default"/>
    <script type="text/javascript">
        $(document).ready(function() {
            //$("#name").focus();
            $("#inputForm").validate({
                submitHandler: function(form){
                    save();
                },
                errorContainer: "#messageBox",
                errorPlacement: function(error, element) {
                    $("#messageBox").text("输入有误，请先更正。");
                    if (element.is(":checkbox")||element.is(":radio")||element.parent().is(".input-append")){
                        error.appendTo(element.parent().parent());
                    } else {
                        error.insertAfter(element);
                    }
                }
            });
            if($("#reviewState").val()==2){
                $("#reviewDiv").show();
            } else {
                $("#reviewDiv").hide();
            }
        });
        function closeLayer(){
            parent.isYes = false;
            parent.layer.closeAll();
        }
        function changeState(val){
             if(val==2){
                 $("#reviewDiv").show();
             } else {
                 $("#reviewDiv").hide();
                 $("#reviewRemarks").val('');
             }
        }
       //打开查询用户的弹窗
       function searchUser(){
            top.layer.open({
                type: 2,
                title: ['会员查询', 'font-size:18px;text-align: center;'],
                shadeClose: false,
                shade: [0.8, '#393D49'],
                maxmin: false, //开启最大化最小化按钮
                area: ['700px', '500px'],
                content: "${ctx}/sys/user/member/search"
            });
        }
       function save(){
    	   var dogId = $("#dogId").val();
           if(dogId==''){
               alert("请先查询出犬只信息！");
               $('#dogId').val('');
               return;
           }
           var frm = $("#inputForm");
           loading('正在提交，请稍等...');
           var dataPara = util.getFormJson(frm);
           $.ajax({
               url: '${ctx}/dogownerchange/dogOwnerChange/orderSave',
               type: 'POST',
               data: dataPara,
               async:false,
               success: function(json){
                   if (json.rc == 0) {
                       layer.msg(json.msg);
                       parent.isYes = true;
                       parent.layer.closeAll();
                   } else {
                       layer.msg(json.msg);
                   }
               }
           });
       }
       //查询用户完成的回调方法
       this.searchUserCallback = function (json){
           $("#newOwnerName").val(json.name);
           $("#newOwnerMemberCode").val(json.memberCode);
       }
       function closeLayer(){
           parent.isYes = false;
           parent.layer.closeAll();
       };
       function getDogByPedigreeCertified(){
           var pedigreeCertified = $("#pedigreeCertified").val();
           if(pedigreeCertified==''){
               alert("请填写血统证书号！");
               $('#dogId').val('');
               return;
           }
           $.post('${ctx}/dogexport/dogPedigreeCertifiedExport/getDogByPedigreeCertified', {
               pedigreeCertified: pedigreeCertified
           }, function(data) {
        	   if(data.dogOwnerMemberCode==$("#newOwnerMemberCode").val()){
        		   alert("原犬主与新犬主不能为同一人！");
        		   $('#dogId').val('');
        	   } else {
        		   $('#dogId').val(data.dogId);
                   $('#originOwnerName').val(data.dogOwner);
                   $('#originOwnerMemberCode').val(data.dogOwnerMemberCode);
        	   }
           });
       }
    </script>
</head>
<body>
    <form:form id="inputForm" modelAttribute="dogOwnerChange" method="post" class="form-horizontal">
        <%--<form:input path="id"/>--%>
        <form:hidden path="runningNumber"/>
        <form:hidden path="dogId"/>
        <!-- <input type="hidden" name="dogOwnerMemberCode" id="dogOwnerMemberCode"> -->
        <sys:message content="${message}"/>
        <div class="control-group">
        </div>
        <div class="control-group">
            <label class="control-label">血统证书号：</label>
            <div class="controls">
                <input id="pedigreeCertified" type="text" htmlEscape="false" maxlength="64" class="input-xlarge ">
                <input id="search" class="btn btn-primary" type="button" value="查" onclick="getDogByPedigreeCertified()"/>
            </div>
        </div>
        <div class="control-group">
            <label class="control-label">原犬主：</label>
            <div class="controls">
                <form:input path="originOwnerName" htmlEscape="false" maxlength="64" class="input-xlarge " readonly="true"/>
            </div>
        </div>
        <div class="control-group">
            <label class="control-label">原犬主会员号：</label>
            <div class="controls">
                <form:input path="originOwnerMemberCode" htmlEscape="false" maxlength="64" class="input-xlarge " readonly="true"/>
            </div>
        </div>
        <div class="control-group">
            <label class="control-label">新犬主：</label>
            <div class="controls">
                <form:input path="newOwnerName" htmlEscape="false" maxlength="64" class="input-xlarge " readonly="true"/>
            </div>
        </div>
        <div class="control-group">
            <label class="control-label">新犬主会员号：</label>
            <div class="controls">
                <form:input path="newOwnerMemberCode" htmlEscape="false" maxlength="64" class="input-xlarge " readonly="true"/>
            </div>
        </div>
        <div class="form-actions">
            <input id="btnSubmit" class="btn btn-primary" type="submit" value="保存"/>&nbsp;
            <input id="btnCancel" class="btn" type="button" value="关闭" onclick="closeLayer()"/>
        </div>
    </form:form>
</body>
</html>