<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>犬只宠爱护照申领</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {

		});
	</script>
	<link rel="stylesheet" href="${ctxStatic}/jquery-ui/1.12.0/jquery-ui.min.css">
    <script src="${ctxStatic}/jquery-ui/1.12.0/jquery-ui.min.js"></script>
</head>
<body>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>芯片号码</th>
				<th>血统证书号</th>
				<th>申请人</th>
				<th>英文犬名</th>
				<th>护照编号</th>
				<th>申请等级</th>
				<th>申请日期</th>
				<th>是否需要新护照</th>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${list}" var="dogStickerApply">
			<tr>
				<td>
					${fns:escapeHtml(dogStickerApply.identificationFlag) }
				</td>
                <td>
                    ${fns:escapeHtml(dogStickerApply.pedigreeCertified) }
                </td>
                <td>
                    ${fns:escapeHtml(dogStickerApply.paymentMemberName) }
                </td>
                <td>
                    ${fns:escapeHtml(dogStickerApply.nameEn) }
                </td>
				<td>
					${fns:escapeHtml(dogStickerApply.cabPassport) }
                </td>
				<td>
						${fns:escapeHtml(dogStickerApply.applyClass) }
				</td>
                <td>
					<fmt:formatDate value="${dogStickerApply.createDate}" pattern="yyyy-MM-dd HH:mm:ss"/>
				</td>
				<td>
					<c:if test="${dogStickerApply.needNewPassport == '1'}">
						<font color="red">是</font>
					</c:if>
					<c:if test="${dogStickerApply.needNewPassport == '0'}">否</c:if>
				</td>
			</tr>
		</c:forEach>
		</tbody>
	</table>
</body>
</html>