/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.subsystem.dog;

import com.cku.oa.dog.entity.Dog;
import com.cku.oa.dog.service.DogService;
import com.cku.oa.show.entity.ChildShows;
import com.cku.oa.show.entity.MainShows;
import com.cku.oa.show.entity.ShowApply;
import com.cku.oa.show.service.ChildShowsService;
import com.cku.oa.show.service.MainShowsService;
import com.cku.oa.show.service.ShowApplyService;
import com.cku.oa.sys.entity.user.Member;
import com.cku.oa.sys.service.LoginServerService;
import com.cku.oa.sys.service.user.MemberService;
import com.google.common.collect.Lists;
import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.modules.sys.dao.UserDao;
import com.thinkgem.jeesite.modules.sys.entity.User;
import com.thinkgem.jeesite.modules.sys.utils.DictUtils;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;
import net.sf.json.JSONObject;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 赛事报名表Controller
 * @author cxt
 * @version 2018-03-05
 */
@Controller
@RequestMapping(value = "/subSystem/showApply")
public class SubShowApplyController extends BaseController {

	@Autowired
	private ShowApplyService showApplyService;
	@Autowired
	private MainShowsService mainShowsService;
	@Autowired
	private MemberService memberService;
	@Autowired
	private LoginServerService loginServerService;
	@Autowired
	private UserDao userDao;

	/**
	 * 查询当前登录人登录类型得到跳转路径头
	 * @return
	 * @author chaixueteng
	 */
	public String getUrlByUserType(){
		User loginUser = UserUtils.getLoginUser();
		return loginServerService.getShortNameByUserType(loginUser.getUserType());
	}
	@ModelAttribute
	public ShowApply get(@RequestParam(required=false) String id) {
		ShowApply entity = null;
		if (StringUtils.isNotBlank(id)){
			entity = showApplyService.get(id);
		}
		if (entity == null){
			entity = new ShowApply();
		}
		return entity;
	}
	
	@RequestMapping(value = {"list", ""})
	public String list(ShowApply showApply, HttpServletRequest request, HttpServletResponse response, Model model) {
		Page<ShowApply> page = showApplyService.findPage(new Page<ShowApply>(request, response), showApply);
		for(ShowApply sa:page.getList()){
			Member member = memberService.getByMemberCode(sa.getDogOwnerMemberCode());
			if(member!=null){
				sa.setAccountBalance(member.getAccountBalance());
			}
		}
		model.addAttribute("page", page);
		return "subSystem/"+getUrlByUserType()+"/dog/apply/showApplyList";
	}

	@RequestMapping(value = "form")
	public String form(ShowApply showApply, Model model) {
		List<MainShows> mainShowsList = mainShowsService.findUnCloseMainShows(null,null,null,null,null);
		model.addAttribute("mainShowsList", mainShowsList);
		List<ChildShows> childShowsList = Lists.newArrayList();
		model.addAttribute("childShowsList", childShowsList);
		//记录修改人
		if(showApply.getUpdateBy()!=null&&StringUtils.isNotBlank(showApply.getUpdateBy().getId())){
			User updateUser = userDao.get(showApply.getUpdateBy().getId());
			showApply.setUpdateBy(updateUser);
		}
		model.addAttribute("showApply", showApply);
		//回显年龄组别
		String ageGroups = showApply.getAgeGroup();
		StringBuilder sb = new StringBuilder();
		if(ageGroups.contains(",")){
			String[] ageGroupArray = ageGroups.split(",");
			for(String ageGroup:ageGroupArray){
				sb.append(DictUtils.getDictLabel(ageGroup,"show_age_group","")).append(",");
			}
		}else{
			String label = DictUtils.getDictLabel(ageGroups,"show_age_group","");
			String[] showCodeArray = showApply.getShowCode().split(",");
			for(int i=0,len=showCodeArray.length;i<len;i++){
				sb.append(label).append(",");
			}
		}
		sb.deleteCharAt(sb.length()-1);
		showApply.setAgeGroup(sb.toString());
		return "subSystem/"+getUrlByUserType()+"/dog/apply/showApplyForm";
	}
}