package com.cku.subsystem.dog;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

import com.cku.oa.dog.entity.DogOwnerChange;
import com.cku.oa.dog.service.DogOwnerChangeService;
import com.cku.oa.sys.service.LoginServerService;
import com.cku.oa.sys.service.user.MemberService;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.modules.sys.entity.User;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

/**
 * 犬主变更申请Controller
 * @author zhuoHeng
 * @version 2016-08-17
 */
@Controller
@RequestMapping(value = "/subSystem/dogOwnerChange")
public class SubDogOwnerChangeController extends BaseController {

	@Autowired
	private DogOwnerChangeService dogOwnerChangeService;
	
	@Autowired
	private MemberService memberService;
	@Autowired
	private LoginServerService loginServerService;
	
	/**
	 * 查询当前登录人登录类型得到跳转路径头
	 * @return
	 * @author chaixueteng
	 */
	public String getUrlByUserType(){
		User loginUser = UserUtils.getLoginUser();
		return loginServerService.getShortNameByUserType(loginUser.getUserType());
	}
	@ModelAttribute
	public DogOwnerChange get(@RequestParam(required=false) String id) {
		DogOwnerChange entity = null;
		if (StringUtils.isNotBlank(id)){
			entity = dogOwnerChangeService.get(id);
		}
		if (entity == null){
			entity = new DogOwnerChange();
		}
		return entity;
	}
	
	@RequestMapping(value = {"list", ""})
	public String list(DogOwnerChange dogOwnerChange, HttpServletRequest request, HttpServletResponse response, Model model) {
		Page<DogOwnerChange> page = dogOwnerChangeService.findPage(new Page<DogOwnerChange>(request, response), dogOwnerChange); 
		model.addAttribute("page", page);
		return "subSystem/"+getUrlByUserType()+"/dog/dogownerchange/dogOwnerChangeList";
	}

	@RequestMapping(value = "form")
	public String form(DogOwnerChange dogOwnerChange, Model model) {
		model.addAttribute("dogOwnerChange", dogOwnerChange);
		return "subSystem/"+getUrlByUserType()+"/dog/dogownerchange/dogOwnerChangeView";
	}
}