package com.cku.restful.v1.sys.web;

import com.cku.core.PageBeanResult;
import com.cku.core.RESTResponse;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.dog.dao.DogBirthCertificateDao;
import com.cku.oa.dog.dao.DogDao;
import com.cku.oa.dog.entity.Dog;
import com.cku.oa.dog.entity.DogBirthCertificate;
import com.cku.oa.dog.entity.DogType;
import com.cku.oa.dog.service.DogTypeService;
import com.cku.oa.sys.entity.Org;
import com.cku.oa.sys.service.OrgDogTypeLimitService;
import com.cku.oa.sys.service.OrgService;
import com.cku.restful.v1.sys.model.RestOrg;
import com.cku.restful.v1.sys.utils.BeanUtil;
import com.cku.util.ServletUtils;
import io.swagger.annotations.*;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * 合作机构、合作医院Controller
 *
 * @author fanhuibin
 * @version 2016-08-22
 */
@Controller
@RequestMapping(value = "/api/v1/org")
public class RestOrgController extends BaseRestController {

	@Autowired
	private OrgService orgService;
	@Autowired
	private OrgDogTypeLimitService orgDogTypeLimitService;
	@Autowired
	private DogTypeService dogTypeService;
	@Autowired
	private DogBirthCertificateDao dogBirthCertificateDao;
	@Autowired
	private DogDao dogDao;

	@RequestMapping(value = "/getHospital", method = RequestMethod.GET)
	@ResponseBody
	public void getHospital(HttpServletRequest request, HttpServletResponse response) throws IOException {
		String provinceName = request.getParameter("provinceName");
		if (StringUtils.isBlank(provinceName)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "provinceName省名称为空");
		}
		Org example = new Org();
		example.setOrgType("hospital");
		example.setAddress(provinceName);
		List<Org> result = orgService.findList(example);
		List<RestOrg> list = new ArrayList<RestOrg>();
		for (Org org : result) {
			// 会员中心新生犬登记申请页面是否显示标记位：显示0；不显示1；
			if ("1".equals(org.getVisibleFlag())) {
				continue;
			}
			RestOrg vo = new RestOrg();
			BeanUtil.copyProperties(vo, org, "yyyy-MM-dd");
			vo.setPhone(org.getUser().getPhone());
			vo.setMobile(org.getUser().getMobile());
			// 不显示过期的合作机构
			if (org.getEndDate() != null && org.getEndDate().getTime() > System.currentTimeMillis()) {
				list.add(vo);
			}
		}
		Long totalCount = (long) list.size();
		ServletUtils.writeResponse(response, new RESTResponse("list", new PageBeanResult<RestOrg>(list, totalCount)));
	}

	/**
	 * 1.
	 *
	 * @description: 证书换发根据省份获取合作机构列表
	 * @author: laiguanglong
	 * @date: 2017/5/8 14:12 2.
	 * @author: zhangxiang
	 * @date: 2019/10/30 10:12 注意：此参数值不统一：String club =
	 *        request.getParameter("mechanism");整窝办理：clubandcatRenZheng
	 *        、单只办理：club或者为空、证书换发：clubchange（2019/10/30之前传club，为区分单只和换发改为clubchange）
	 *        所有查询俱乐部的都用了此接口：分别来自cku 、杜高 、马犬会员中心、Android、IOS、H5
	 */

	@ApiOperation(value = "血统证书-合作机构列表", tags = { "血统证书-zxy" })
	@ApiImplicitParams({ @ApiImplicitParam(name = "provinceName", value = "北京市"),
			@ApiImplicitParam(name = "dogBreed", value = "犬种"),
			@ApiImplicitParam(name = "mechanism", value = "整窝办理：clubandcatRenZheng、证书换发：clubchange、血样留存单只办理为空"),
			@ApiImplicitParam(name = "birthCode", paramType = "query", value = "登记卡编号"),
			@ApiImplicitParam(name = "token", paramType = "query", value = "token") })
	@ApiResponses({ @ApiResponse(code = 0, message = "{    \n" + "	\"rc\": 0,\n" + "	    \"msg\": \"OK\",\n"
			+ "	    \"list\": [        {            \n" + "		\"address\": \"北京市崇文区黑龙江街道\",\n"
			+ "		            \"city\": \"崇文区\",\n" + "		            \"mobile\": \"\",\n"
			+ "		            \"dogTypeList\": [\n" + "\n" + "			            \n" + "		],\n"
			+ "		            \"displayOnWeb\": \"0\",\n" + "		            \"orgType\": \"catRenZheng\",\n"
			+ "		            \"province\": \"北京市\",\n" + "		            \"phone\": \"\",\n"
			+ "		            \"street\": \"黑龙江街道\",\n" + "		            \"contact\": \"犬猫测试\",\n"
			+ "		            \"name\": \"犬猫测试\",\n" + "		            \"tel\": \"16572717721\",\n"
			+ "		            \"id\": \"a61cf0c2cbb44bc893a5f6c90109836c\",\n"
			+ "		            \"orgDogType\": \"\"        \n" + "	}    ],\n" + "	    \"total\": 1\n" + "}") })
	@RequestMapping(value = "", method = RequestMethod.GET)
	@ResponseBody
	public void getOrg(HttpServletRequest request, HttpServletResponse response) throws IOException {
		String provinceName = request.getParameter("provinceName");
		// 犬种
		String birthCode = request.getParameter("birthCode");
		String dogBreed = request.getParameter("dogBreed");
		if (StringUtils.isBlank(provinceName)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "provinceName省名称为空");
		}
		DogType dogType = null;
		if (StringUtils.isNotBlank(dogBreed)) {
			dogType = dogTypeService.getByDogBreedCode(dogBreed);
		}
		String club = request.getParameter("mechanism");
		Org example = new Org();
		if(StringUtils.isNotBlank(dogBreed) && dogBreed.equals("15C")){
			example.setOrgSite("2");
		}else if(StringUtils.isNotBlank(dogBreed) && !dogBreed.equals("15C")){
			example.setOrgSite("1");
		}else{
			DogBirthCertificate dogBirthCertificate = dogBirthCertificateDao.getByBirthCerRegCode(birthCode);
			if(dogBirthCertificate != null){
				if("15C".equals(dogBirthCertificate.getDogBreed())){
					example.setOrgSite("2");
				}else{
					example.setOrgSite("1");
				}
			}else{
				Dog dog = dogDao.getByPedigreeCertifiedCode(birthCode);
				if("15C".equals(dog.getDogBreed())){
					example.setOrgSite("2");
				}else{
					example.setOrgSite("1");
				}
			}
		}
		example.setAddress(provinceName);
		List<Org> result = orgService.findList(example);
		List<RestOrg> list = new ArrayList<RestOrg>();
		// 20200810 单只改为 合作医院hospital，俱乐部club，纯种犬认证中心catRenZheng
		// 20200810 整窝改为 俱乐部club，纯种犬认证中心catRenZheng
		for (Org org : result) {
			// 对于证书换发，会员只可以选择在俱乐部办理。对于整窝办证，会员可以选择在俱乐部或认证中心办理。
			if (StringUtils.isNotEmpty(club) && club.equals("clubandcatRenZheng")) {// 整窝办理
				if (org.getOrgType().equals("club") || org.getOrgType().equals("catRenZheng")) {
					// 继续执行
				} else {
					continue;
				}
			} else {
				// 如果犬种不为空，表示来自cku 否则来着杜高马全
				if (StringUtils.isNotBlank(dogBreed)) {
					if (StringUtils.isNotBlank(club) && club.equals("clubchange")) {// 证书换发
						if (org.getOrgType().equals("club") || org.getOrgType().equals("singleTypeClub")
								|| org.getOrgType().equals("hospital")) {

						} else {
							continue;
						}
					} else {// 单只办理证书
						if (org.getOrgType().equals("club") || org.getOrgType().equals("catRenZheng")
								|| org.getOrgType().equals("hospital")) {

						} else {
							continue;
						}
					}
				} else {
					// 杜高马犬
					if (StringUtils.isNotBlank(club) && club.equals("clubchange")) {// 证书换发
						if (org.getOrgType().equals("club") || org.getOrgType().equals("hospital")) {

						} else {
							continue;
						}
					} else {// 单只办理证书
						if (org.getOrgType().equals("club") || org.getOrgType().equals("catRenZheng")
								|| org.getOrgType().equals("hospital")) {

						} else {
							continue;
						}
					}
				}
			}
			// 会员中心新生犬登记申请页面是否显示标记位：显示0；不显示1；
			if ("1".equals(org.getVisibleFlag())) {
				continue;
			}
			RestOrg vo = new RestOrg();
			BeanUtil.copyProperties(vo, org, "yyyy-MM-dd");
			vo.setPhone(org.getUser().getPhone());
			vo.setMobile(org.getUser().getMobile());
			// 不显示过期的合作机构
			if (org.getEndDate() != null && org.getEndDate().getTime() > System.currentTimeMillis()) {
				if (StringUtils.isNotBlank(dogBreed) && org.getOrgType().equals("singleTypeClub")) {// 根据犬种判断,单犬种俱乐部是否可显示
					// 查询以有犬种数据
					List<String> originalList = orgDogTypeLimitService.findTypeByOrgId(org.getId());
					for (String orgLimit : originalList) {
						if (StringUtils.isNotBlank(orgLimit) && orgLimit.equals(dogType.getId())) {
							list.add(vo);
							break;
						}
					}
				} else {
					list.add(vo);
				}
			}
		}
		Long totalCount = (long) list.size();
		ServletUtils.writeResponse(response, new RESTResponse("list", new PageBeanResult<RestOrg>(list, totalCount)));
	}

}