package com.cku.restful.v1.sys.web;

import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.finance.entity.PaymentOrder;
import com.cku.oa.finance.entity.PaymentPayLog;
import com.cku.oa.finance.service.PaymentOrderService;
import com.cku.oa.finance.service.PaymentPayLogService;
import com.cku.oa.shop.entity.ShopOrder;
import com.cku.oa.shop.service.ShopOrderService;
import com.cku.restful.v1.finance.service.RestOrderService;
import com.cku.restful.v1.show.service.RestShowApplyService;
import com.cku.restful.v1.sys.utils.allinpay.SybConstants;
import com.cku.restful.v1.sys.utils.allinpay.SybPayService;
import com.cku.restful.v1.sys.utils.allinpay.SybUtil;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.thinkgem.jeesite.common.config.Global;
import org.apache.avalon.framework.ExceptionUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.awt.image.BufferedImage;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;
import java.util.TreeMap;

@Controller
@RequestMapping(value = "/api/v1/open/allinpay")
/**
 * 通联支付
 * @author yuanshuai
 *
 */
public class AllinpayController extends BaseRestController {
    @Autowired
    private PaymentOrderService paymentOrderService;
    @Autowired
    private RestOrderService restOrderService;
    @Autowired
    private ShopOrderService shopOrderService;
    @Autowired
    private RestShowApplyService restShowApplyService;
    @Autowired
    private PaymentPayLogService paymentPayLogService;
    private Logger logger = LoggerFactory.getLogger(AllinpayController.class);

    @RequestMapping(value = "/pay/{orderId}", method = RequestMethod.GET)
    @ResponseBody
    public void pay(@PathVariable String orderId, HttpServletRequest request, HttpServletResponse response) throws IOException {
        //判断订单是否存在，是否为未付款
        String totalPrice = "";
        String memberName = "";
        String title = "";
        String paymentWay = request.getParameter("paymentWay");
        //判断支付方式
        if (StringUtils.isBlank(paymentWay) && (!paymentWay.equals("1") || !paymentWay.equals("24"))) {
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "支付方式有误，请重试");
        }
        paymentWay = paymentWay.replace("1", "A01").replace("24", "W01");
        PaymentOrder order = paymentOrderService.get(orderId);
        //如果订单已删除。报错提示
        if ("1".equals(order.getDelFlag())) {
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该订单已删除，请勿支付");
        }
        if (order != null && order.getPaymentState().equals("1")) {
            totalPrice = order.getTotalPrice();
            memberName = order.getMemberName();
            title = "CKU业务扣费";
            //支付宝、微信支付不允许支付包含赛事报名的订单
            if (restShowApplyService.isShowApplyOrder(order)) {
                BufferedImage image = ImageIO.read(new FileInputStream(AllinpayController.class.getResource("/").getPath() + "wxPayWarn2.png"));
                ImageIO.write(image, "png", response.getOutputStream());// 输出png图片
                return;
            }
        } else {
            //判断是否是商城订单
            ShopOrder sOrder = shopOrderService.get(orderId);
            if (sOrder != null && sOrder.getPaymentState().equals("1")) {
                totalPrice = sOrder.getPrice();
                memberName = sOrder.getMemberName();
                title = "CKU商城扣费";
            } else {
                throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "订单验证失败");
            }
        }
        if (Global.isDevMode()) {
            totalPrice = "0.01";
        }
        try {
            //把金额转成分为单位
            Map<String, String> payResponse = SybPayService.pay(request, (long) (Double.parseDouble(totalPrice) * 100), orderId, paymentWay, title, "CKU会员" + memberName + "的业务缴费");
            //验证是否成功
            if (!"SUCCESS".equals(payResponse.get("retcode").toUpperCase()) && !payResponse.containsKey("payinfo")) {
                throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "订单验证失败");
            }
            int width = 300;
            int height = 300;
            Hashtable hints = new Hashtable();
            hints.put(EncodeHintType.CHARACTER_SET, "utf-8");
            BitMatrix bitMatrix = new MultiFormatWriter().encode(payResponse.get("payinfo"), BarcodeFormat.QR_CODE, width, height, hints);
            MatrixToImageWriter.writeToStream(bitMatrix, "png", response.getOutputStream());
            //增加支付日志
            paymentPayLogService.savePayLog(order.getId(), "30");
        } catch (Exception e) {
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, e.getMessage());
        }
    }

    /**
     * 异步通知，请不要随便修改这个url，会影响付款功能
     *
     * @param request
     * @param response
     * @throws IOException
     */
    @RequestMapping(value = "/notifyUrl")
    @ResponseBody
    public void notifyUrl(HttpServletRequest request, HttpServletResponse response) throws IOException {
        logger.info("通联回调开始:");
        request.setCharacterEncoding("gbk");//通知传输的编码为GBK
        response.setCharacterEncoding("gbk");
        TreeMap<String, String> params = getParams(request);//动态遍历获取所有收到的参数,此步非常关键,因为收银宝以后可能会加字段,动态获取可以兼容
        logger.info(params.toString());
        try {
            // 接受到推送通知,首先验签
            boolean isSign = SybUtil.validSign(params, SybConstants.SYB_APPKEY);
            //验签完毕进行业务处理
            if (isSign) {
                afterPayOrder(params);
            }
        } catch (Exception e) {//处理异常
            e.printStackTrace();
        } finally {//收到通知,返回success
            response.getWriter().write("success");
        }
    }

    /**
     * 动态遍历获取所有收到的参数,此步非常关键,因为收银宝以后可能会加字段,动态获取可以兼容由于收银宝加字段而引起的签名异常
     *
     * @param request
     * @return
     */
    private TreeMap<String, String> getParams(HttpServletRequest request) {
        TreeMap<String, String> map = new TreeMap<>();
        Map reqMap = request.getParameterMap();
        for (Object key : reqMap.keySet()) {
            String value = ((String[]) reqMap.get(key))[0];
            map.put(key.toString(), value);
        }
        return map;
    }

    private void afterPayOrder(TreeMap<String, String> params) {
        String orderId = params.get("cusorderid");
        String outtrxid = params.get("outtrxid");
        try {
            //保存回调的支付日志
            paymentPayLogService.updatePayInfo(orderId, outtrxid, params.toString());
            PaymentOrder order = paymentOrderService.get(orderId);
            if (order != null && !StringUtils.isEmpty(order.getOrderCode())) {
                if (order.getPaymentState().equals("1")) {
                    //会员端支付后处理逻辑
                    order.setPaymentWay("30");
                    order.setTransactionId(outtrxid);
                    restOrderService.afterPay(order);
                    //修改支付日志支付状态
                    paymentPayLogService.updatePayState(orderId,"2", null);
                } else {
                    //不做任何处理
                    logger.info("已处理的订单");
                }
            } else {
                //判断是否是商城订单
                ShopOrder sOrder = shopOrderService.get(orderId);
                if (sOrder != null && sOrder.getPaymentState().equals("1")) {
                    sOrder.setPaymentWay("30");
                    shopOrderService.clientPay(sOrder);
                    //修改支付日志支付状态
                    paymentPayLogService.updatePayState(orderId,"2",null);
                } else {
                    //可能是已经被处理过的订单，不做处理直接放过
                    //以前抛出异常是错误的
                    //throw new ZAException(ZAErrorCode.ZA_VALID_FAILED,"订单验证失败");
                    logger.info("已处理的商城订单");
                }
            }
        } catch (Exception e) {
            logger.error("通联支付回调，业务处理失败。", e);
            //修改支付日志支付状态
            paymentPayLogService.updatePayState(orderId,"3", ExceptionUtil.printStackTrace(e));
        }
    }
}
