package com.cku.restful.v1.sys.service;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.servlet.http.HttpServletRequest;

import com.cku.oa.kennel.dao.KennelDao;
import com.cku.oa.kennel.entity.Kennel;
import com.cku.oa.sys.entity.user.Member;
import com.cku.oa.sys.util.MemberUtil;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.cku.core.RESTResponse;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.sys.dao.user.MemberDao;
import com.cku.restful.v1.sys.model.RestMember;
import com.cku.util.JSONUtils;

import net.sf.json.JSONArray;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;

@Service
@Transactional(readOnly = true)
public class CkuMemberServide {

	@Autowired
	public MemberDao memberDao;
	@Autowired
	public KennelDao kennelDao;

	/**
	 * 
	 * @Description：根据会员号/手机号获取会员信息（CKU官网使用）
	 * @author: zhuoHeng
	 * @version: 2016年9月23日 下午6:57:14
	 */
	public RESTResponse getMemberByMobile(HttpServletRequest request) {
		String mobile = request.getParameter("mobile");
		if (StringUtils.isBlank(mobile)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "会员手机号为空");
		}
		List<RestMember> memberList = memberDao.getByMobile(mobile);
		JSONObject jo = new JSONObject();
		JSONArray ja = new JSONArray();
		for (RestMember restMember : memberList) {
			JSONObject member = new JSONObject();
			member.put("memberCode", restMember.getMemberCode());
			member.put("name", restMember.getName());
			member.put("memberType", restMember.getMemberType());
			member.put("memberEndDate", restMember.getMemberEndDate());
			ja.add(member);
		}
		jo.put("list", ja);
		return new RESTResponse(jo);
	}

	public RESTResponse getInfoByCode(HttpServletRequest request) {
		String memberCode = request.getParameter("memberCode");
		if (StringUtils.isBlank(memberCode)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "会员号为空");
		}
		Member member = memberDao.getByMemberCode(memberCode);
		JSONObject jsonObject = new JSONObject();
		jsonObject.put("memberCode", member.getMemberCode());
		jsonObject.put("name", member.getName());
		jsonObject.put("cardNo",member.getCardNo());
		jsonObject.put("mobile",member.getMobile());
		return new RESTResponse("data",jsonObject);
	}
	/**
	 * 
	 * @Description：根据会员号获取会员信息
	 * @author: zhuoHeng
	 * @version: 2017年3月14日 下午3:07:16
	 */
	public JSONObject getClientInfo(String json) {
		JSONObject vo = JSONObject.fromObject(json);
		String mobile = vo.getString("mobile");
		boolean mob =  false;
		if(StringUtils.isNotBlank(mobile)){
			Pattern p = Pattern.compile("^((13[0-9])|(14[0-9])|(17[0-9])|(15[0-9])|(18[0-9]))\\d{8}$");  
			Matcher m = p.matcher(mobile);
			mob = m.find();
		}
		int code = 200;
		String message = "成功";
		JSONObject dat = new JSONObject();
		JSONObject member = new JSONObject();
		if (StringUtils.isBlank(mobile)||!mob) {
			code = 403;
			message = "失败";
			member.put("memberId", "");
			member.put("clientName", "");
			member.put("type", "");
			dat.put("code", code);
			dat.put("message", message);
			dat.put("data", JSONUtils.convertObject(member));
		} else {
			List<RestMember> memberList;
			try {
				memberList = memberDao.getByMobile(mobile);
				if(memberList.size()>0){
					member.put("memberId", memberList.get(0).getMemberCode());
					member.put("clientName", memberList.get(0).getName());
					String memberType = "无会员类型";
					if("professional".equals(memberList.get(0).getMemberType())){
						memberType = "专业会员";
					} else if("basic".equals(memberList.get(0).getMemberType())) {
						memberType = "基础会员";
					} else if("foreign".equals(memberList.get(0).getMemberType())){
						memberType = "外籍会员";
					}
					member.put("type", memberType);
				} else {
					member.put("memberId", "");
					member.put("clientName", "");
					member.put("type", "");
				}
				dat.put("code", code);
				dat.put("message", message);
				dat.put("data", JSONUtils.convertObject(member));
			} catch (Exception e) {
				if(e instanceof IOException){
					dat.put("code", 1);
					dat.put("message", "请求发生异常");
					dat.put("data", JSONUtils.convertObject(member));
				} else if(e instanceof JSONException){
					dat.put("code", 401);
					dat.put("message", "数据格式错误");
					dat.put("data", JSONUtils.convertObject(member));
				} else {
		        	e.printStackTrace();
		        	dat.put("code", 1);
					dat.put("message", "服务器处理数据发生异常");
					dat.put("data", JSONUtils.convertObject(member));
				}
			} finally {
				
			}
		}
		return dat;
	}
	
	/**
	 * 
	 * @Description：验证输入的手机号是否存在会员
	 * @author: zhuoHeng
	 * @version: 2017年5月16日 下午6:06:54
	 */
	public Map<String, Boolean> validateIsMemberByMobile(HttpServletRequest request) {
		String mobile = request.getParameter("mobile");
		if (StringUtils.isBlank(mobile)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "会员手机号为空");
		}
		List<RestMember> memberList = memberDao.getByMobile(mobile);
		Map<String, Boolean> map = new HashMap<>();
		map.put("result", false);
		if(memberList.size()>0){
			Member member = memberDao.getByMemberCode(memberList.get(0).getMemberCode());
			if(member!=null&&MemberUtil.isActiveMember(member)){
				Kennel kennel = kennelDao.getKennelByMemberCode(member.getMemberCode());
				if(kennel!=null&&kennel.getEndTime()!=null&&kennel.getEndTime().getTime()+86400000>System.currentTimeMillis()){
					map.put("result", true);
				}
			}
		}
		return map;
	}

}
