package com.cku.restful.v1.dog.vo.request;

import java.io.Serializable;

import javax.validation.constraints.Pattern;

import org.hibernate.validator.constraints.NotBlank;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@ApiModel
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class GoldCertifiedApplyAuditRequest implements Serializable {

	private static final long serialVersionUID = -5308225460555332261L;

	@ApiModelProperty("审核记录ID")
	@NotBlank(message = "id不能为空")
	private String id;

	@ApiModelProperty("要同意犬只的血统证书号：父母犬只要分开同意，审核哪只就传哪只")
	@NotBlank(message = "审核证书号不能为空")
	private String pedigreeCertifiedCode;

	@ApiModelProperty("审核状态1同意 2不同意")
	@NotBlank
	@Pattern(regexp = "1|2", message = "审核状态只能传入1或者2")
	private String reviewState;

	@ApiModelProperty("审核意见：非必填")
	private String reviewRemarks;

	@ApiModelProperty("短信验证码")
	private String smsCode;

}
