/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.restful.v1.dog.service;

import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.cku.core.PageBeanResult;
import com.cku.core.RESTResponse;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.dog.dao.DogSemenDao;
import com.cku.oa.dog.entity.DogSemen;
import com.cku.oa.dog.service.DogSemenService;
import com.cku.oa.sys.entity.user.Member;
import com.cku.oa.sys.service.LoginServerService;
import com.cku.util.DateUtils;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

import net.sf.json.JSONObject;

@Service
@Transactional(readOnly = true)
public class RestDogSemenService {

	@Autowired
	public DogSemenDao dogSemenDao;
	@Autowired
	public DogSemenService dogSemenService;
	@Autowired
	public LoginServerService loginServerService;

	public RESTResponse get(String id) {
		Member member = UserUtils.getLoginMember();
		DogSemen po = dogSemenService.get(id);
		if (po == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "id有误");
		}
		if (!po.getMemberCode().equals(member.getMemberCode())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "id有误");
		}
		JSONObject data = new JSONObject();
		data.put("id", getString(po.getId()));
		dogSemenService.setDogInfo(po.getDogId(), data);
		data.put("originalSemenCode", getString(po.getOriginalSemenCode()));
		data.put("semenCode", getString(po.getSemenCode()));
		data.put("breedCertifiedCode", getString(po.getBreedCertifiedCode()));
		return new RESTResponse("data", data);
	}

	public RESTResponse getList(HttpServletRequest request) {
		// 获取参数
		String semenBatchCode = request.getParameter("semenBatchCode");
		String pedigreeCertified = request.getParameter("pedigreeCertified");
		String semenCode = request.getParameter("semenCode");
		String pageNo = request.getParameter("pageNo");
		String pageSize = request.getParameter("pageSize");
		String keyword = request.getParameter("keyword");// cku证书号或者cku精子编号

		// 参数校验
		int pageNoInt = 1;
		int pageSizeInt = 10;
		try {
			if (StringUtils.isNotBlank(pageNo)) {
				pageNoInt = Integer.parseInt(pageNo);
			}
			if (StringUtils.isNotBlank(pageSize)) {
				pageSizeInt = Integer.parseInt(pageSize);
			}
		} catch (Exception e) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "pageNo和pageSize必须都为数字");
		}
		DogSemen example = new DogSemen();
		// 设置分页参数
		Page<DogSemen> page = new Page<DogSemen>();
		page.setPageNo(pageNoInt);
		page.setPageSize(pageSizeInt);
		// 设置查询条件
		example.setMemberCode(UserUtils.getLoginMember().getMemberCode());
		example.setHaveSemenCode("1");
		example.setPage(page);
		if (StringUtils.isNotBlank(semenBatchCode)) {
			example.setSemenBatchCodeLike(semenBatchCode);
		}
		if (StringUtils.isNotBlank(pedigreeCertified)) {
			example.setPedigreeCertifiedAndDogChipLike(pedigreeCertified);
		}
		if (StringUtils.isNotBlank(semenCode)) {
			example.setSemenCodeLike(semenCode);
		}
		// 根据当前登录是否杜高会员来判断个人狗列表是杜高犬还是CKU犬
		if (StringUtils.isBlank(example.getDogBreed())) {
			// 根据当前登录端查询犬种
			example.getSqlMap().put("dogBreedMap", loginServerService.dataScopeFilter());
		} else {
			example.getSqlMap().put("dogBreedMap", " ='" + example.getDogBreed() + "'");
		}
		if (StringUtils.isNotBlank(keyword)) {
			example.setKeyword(keyword);
		}
		// 查询并组装返回对象
		Page<DogSemen> result = dogSemenService.findPage(page, example);
		List<DogSemen> dogSemenList = result.getList();
		List<JSONObject> list = new ArrayList<JSONObject>();
		for (DogSemen po : dogSemenList) {
			JSONObject vo = new JSONObject();
			vo.put("id", getString(po.getId()));
			vo.put("semenBatchCode", getString(po.getSemenBatchCode()));
			vo.put("memberCode", getString(po.getMemberCode()));
			vo.put("memberName", getString(po.getMemberName()));
			vo.put("semenCode", getString(po.getSemenCode()));
			vo.put("breedCertifiedCode", getString(po.getBreedCertifiedCode()));
			vo.put("createDate", getString(DateUtils.dateToStr(po.getCreateDate())));
			dogSemenService.setDogInfo(po.getDogId(), vo);
			list.add(vo);
		}
		long count = result.getCount();
		return new RESTResponse("list", new PageBeanResult<JSONObject>(list, count));
	}

	private String getString(String str) {
		return str == null ? "" : str;
	}
}