package com.cku.restful.v1.contest.web;

import com.cku.core.RESTResponse;
import com.cku.restful.v1.contest.service.RestCkuContestService;
import com.cku.restful.v1.sys.web.BaseRestController;
import com.cku.util.ServletUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;

/**
 * @Description： 赛场接口
 * @author: yuanshuai
 * @date: 2020/11/4 14:48
 */
@Controller
@RequestMapping(value = "/open/v1/contest")
public class RestCkuContestController extends BaseRestController {

	@Autowired
	public RestCkuContestService restCkuContestService;

	@GetMapping(value = "/mainShow")
	@ResponseBody
	public void getMainShowList(HttpServletRequest request, HttpServletResponse response) throws IOException {
		ServletUtils.writeResponse(response, new RESTResponse("items", restCkuContestService.getMainShowList()));
	}

	@GetMapping(value = "/childShow")
	@ResponseBody
	public void getChildShowList(HttpServletRequest request, HttpServletResponse response) throws IOException {
		ServletUtils.writeResponse(response, new RESTResponse("items", restCkuContestService.getChildShowList(request)));
	}

	@GetMapping(value = "/applyDog")
	@ResponseBody
	public void getApplyDogList(HttpServletRequest request, HttpServletResponse response) throws IOException {
		ServletUtils.writeResponse(response, new RESTResponse("items", restCkuContestService.getApplyDogList(request)));
	}

	@PostMapping(value = "/applyDog")
	@ResponseBody
	public void updateApplyDog(@RequestBody String json, HttpServletRequest request, HttpServletResponse response) throws IOException {
		restCkuContestService.updateApplyDog(json);
		ServletUtils.writeResponse(response, new RESTResponse());
	}

	@GetMapping(value = "/breed")
	@ResponseBody
	public void getBreedList(HttpServletRequest request, HttpServletResponse response) throws IOException {
		ServletUtils.writeResponse(response, new RESTResponse("items", restCkuContestService.getBreedList()));
	}

	@GetMapping(value = "/setting")
	@ResponseBody
	public void getSettingData(HttpServletRequest request, HttpServletResponse response) throws IOException {
		ServletUtils.writeResponse(response, new RESTResponse("data", restCkuContestService.getSettingData(request)));
	}

	@GetMapping(value = "/winners")
	@ResponseBody
	public void getWinnersAndApplyDog(HttpServletRequest request, HttpServletResponse response) throws IOException {
		ServletUtils.writeResponse(response, new RESTResponse("data", restCkuContestService.getWinnersAndApplyDog(request)));
	}

	@PostMapping(value = "/winner")
	@ResponseBody
	public void updateWinner(HttpServletRequest request, HttpServletResponse response) throws IOException, InvocationTargetException, IllegalAccessException {
		restCkuContestService.updateWinner(request);
		ServletUtils.writeResponse(response, new RESTResponse());
	}

	@PostMapping(value = "/winners")
	@ResponseBody
	public void updateWinners(@RequestBody String json, HttpServletRequest request, HttpServletResponse response) throws IOException {
		restCkuContestService.updateWinners(json);
		ServletUtils.writeResponse(response, new RESTResponse());
	}

}
