/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.partner.club.service;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.dog.entity.DogBirthCertificate;
import com.cku.oa.dog.entity.DogBloodSave;
import com.cku.oa.dog.entity.DogChip;
import com.cku.oa.dog.entity.DogChipChange;
import com.cku.oa.dog.entity.DogDnaArchive;
import com.cku.oa.dog.entity.DogDnaParentsCompare;
import com.cku.oa.dog.service.DogBloodSaveService;
import com.cku.oa.dog.service.DogChipChangeService;
import com.cku.oa.dog.service.DogChipService;
import com.cku.oa.dog.service.DogDnaArchiveService;
import com.cku.oa.dog.service.DogDnaParentsCompareService;
import com.cku.oa.finance.dao.PaymentOrderDao;
import com.cku.oa.finance.dao.PaymentOrderDetailDao;
import com.cku.oa.finance.entity.PaymentChargingItem;
import com.cku.oa.finance.entity.PaymentOrder;
import com.cku.oa.finance.entity.PaymentOrderDetail;
import com.cku.oa.sys.entity.Org;
import com.cku.oa.sys.entity.user.Member;
import com.cku.oa.sys.util.DateUtils;
import com.cku.restful.v1.dog.service.RestDogChipService;
import com.cku.restful.v1.finance.service.RestOrderService;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

/**
 * 新生犬登记Service
 * 
 * @author zhuoHeng
 * @version 2016-08-04
 */
@Service
@Transactional(readOnly = true)
public class ClubDogChipService {

	//private static final String CHIP_FEE = "dog_chip@chip_All";
	//private static final String PEDIGREECERTIFIED_FEE = "dog_chip@All";
	//private static final String CLUB_FEE = "dog_chip@club";
	public static Long newBusinessTimeMillis = null;
	static{
		try {
			newBusinessTimeMillis = new SimpleDateFormat("yyyy-MM-dd").parse("2017-06-01").getTime();
		} catch (ParseException e) {
			System.out.println("出生纸判断新旧业务记录格式化时间出错");
		}
	}
	@Autowired
	private RestOrderService restOrderService;
	@Autowired
	private DogDnaParentsCompareService dogDnaParentsCompareService;
	@Autowired
	private DogDnaArchiveService dogDnaArchiveService;
	@Autowired
	private DogBloodSaveService dogBloodSaveService;
	@Autowired
	private PaymentOrderDetailDao paymentOrderDetailDao;
	@Autowired
	private DogChipService dogChipService;
	@Autowired
	private DogChipChangeService dogChipChangeService;
	@Autowired
	private PaymentOrderDao paymentOrderDao;
	@Autowired
	private RestDogChipService restDogChipService;

	/**
	 * 
	 * @description: 俱乐部新生犬登记直接加入订单
	 * @author: laiguanglong
	 * @date: 2016年10月13日 下午2:41:03
	 */
	@Transactional(readOnly = false)
	public List<PaymentOrderDetail> addToOrder(DogBirthCertificate dogBirthCertificate,DogChip dogChip) {
		//设置订单基本字段
		PaymentOrder paymentOrder = buildPaymentOrder(dogBirthCertificate);
		//构造订单详情列表
		List<PaymentOrderDetail> paymentOrderDetailList = buildPaymentOrderDetailList(paymentOrder,dogBirthCertificate,dogChip);
		//计算订单总额
		Double orderTotal = 0d;
		for(PaymentOrderDetail detail:paymentOrderDetailList){
			orderTotal = orderTotal+Double.parseDouble(detail.getTotalPrice());
		}
		dogChip.setFloatingPrice(new BigDecimal(orderTotal));
		dogChipService.updateBusinessPrice(dogChip);
		//保存订单
		restOrderService.saveOrder(paymentOrder, orderTotal, paymentOrder.getAddTime());
		//回写订单详情的OrderCode字段
		for(PaymentOrderDetail detail:paymentOrderDetailList){
			detail.setOrderCode(paymentOrder.getOrderCode());
		}
		//保存订单详情
		for(PaymentOrderDetail detail:paymentOrderDetailList){
			detail.preInsert();
			paymentOrderDetailDao.insert(detail);
		}
		//更新业务表流水号
		for (PaymentOrderDetail paymentOrderDetail : paymentOrderDetailList) {
			//更新业务表不为空且不为会员表的收费项
			if(StringUtils.isNotBlank(paymentOrderDetail.getBusinessTable())&&!"sys_member".equals(paymentOrderDetail.getBusinessTable())&&!"kennel".equals(paymentOrderDetail.getBusinessTable())){
				String businessIds = paymentOrderDetail.getBusinessIds();
				if(businessIds.contains(",")){
					String[] bids = businessIds.split(",");
					for(int j=0;j<bids.length;j++){
						paymentOrderDao.updateBusinessRunningNo(paymentOrder.getOrderCode(), paymentOrderDetail.getBusinessTable(), bids[j]);
					}
				}else{
					paymentOrderDao.updateBusinessRunningNo(paymentOrder.getOrderCode(), paymentOrderDetail.getBusinessTable(), businessIds);
				}
			}
		}
		return paymentOrderDetailList;
	}
	/**
	 * 
	 * @description: 设置订单基本字段
	 * @author: laiguanglong
	 * @date: 2016年10月13日 下午7:21:55
	 */
	private PaymentOrder buildPaymentOrder(DogBirthCertificate dogBirthCertificate){
		PaymentOrder order = new PaymentOrder();
		Org org = (Org) UserUtils.getSession().getAttribute("org");
		Member member = org.getMember();
		order.setMemberCode(dogBirthCertificate.getTempMemberCode());
		order.setMemberName(dogBirthCertificate.getTempUserName());
		order.setAddTime(new Date());
		order.setSource(member.getLoginType());
		return order;
	}
	
	/**
	 * 
	 * @description: 构造订单详情列表
	 * @author: laiguanglong
	 * @date: 2016年10月13日 下午7:22:16
	 */
	@Transactional(readOnly = false)
	private List<PaymentOrderDetail> buildPaymentOrderDetailList(PaymentOrder paymentOrder, DogBirthCertificate dogBirthCertificate, DogChip dogChip) {
		List<PaymentOrderDetail> paymentOrderDetailList = new ArrayList<>();
		//收费项-信息管理费
		// 判断新旧出生纸
		PaymentOrderDetail detail1 = initOrderDetail(paymentOrder);
		if (dogBirthCertificate.getCreateDate().getTime() < newBusinessTimeMillis) {
			//旧出生纸：芯片费、电子芯片埋植服务费
			PaymentChargingItem chipItem = restDogChipService.getChipItem();
			PaymentChargingItem chipEmbedItem = restDogChipService.getChipEmbedItem();
			// 计算芯片费用
			detail1.setTotalPrice(chipItem.getPrice());
			detail1.setNum("1");
			detail1.setPrice(chipItem.getPrice());
			detail1.setBusinessIds(dogChip.getId());
			detail1.setBusinessTable("dog_chip");
			detail1.setChargingItemId(chipItem.getId());
			detail1.setChargingItemName(chipItem.getName());
			//查找芯片变更表
			DogChipChange dogChipChange = dogChipChangeService.getByIdentificationFlag(dogBirthCertificate.getIdentificationFlag());
			PaymentOrderDetail detail2 = initOrderDetail(paymentOrder);
			detail2.setTotalPrice(chipEmbedItem.getPrice());
			detail2.setNum("1");
			detail2.setPrice(chipEmbedItem.getPrice());
			detail2.setBusinessIds(dogChipChange.getId());
			detail2.setBusinessTable("dog_chip_change");
			detail2.setChargingItemId(chipEmbedItem.getId());
			detail2.setChargingItemName(chipEmbedItem.getName());
			paymentOrderDetailList.add(detail2);
		}else{
			//新出生纸：信息管理费（信息匹配）
			PaymentChargingItem infoMatchItem = restDogChipService.getInfoMatchItem();
			detail1.setTotalPrice(infoMatchItem.getPrice());
			detail1.setNum("1");
			detail1.setPrice(infoMatchItem.getPrice());
			detail1.setBusinessIds(dogChip.getId());
			detail1.setBusinessTable("dog_chip");
			detail1.setChargingItemId(infoMatchItem.getId());
			detail1.setChargingItemName(infoMatchItem.getName());
		}
		paymentOrderDetailList.add(detail1);

		//收费项-建档服务费
		PaymentChargingItem saveInfoItem;
		PaymentOrderDetail detail3 = initOrderDetail(paymentOrder);
		if (DateUtils.isInXMounth(dogBirthCertificate.getDogBirthday(), 12)) {
			//1岁内：建档费服务费（新生幼犬）
			saveInfoItem = restDogChipService.getSaveInfoItem(dogBirthCertificate.getBirthCerRegCode());
			detail3.setTotalPrice(saveInfoItem.getPrice());
			detail3.setNum("1");
			detail3.setPrice(saveInfoItem.getPrice());
			detail3.setBusinessIds(dogChip.getId());
			detail3.setBusinessTable("dog_chip");
			detail3.setChargingItemId(saveInfoItem.getId());
			detail3.setChargingItemName(saveInfoItem.getName());
		} else if (DateUtils.isInXMounth(dogBirthCertificate.getDogBirthday(), 24)) {
			//1岁-2岁：建档费服务费（青年犬）
			saveInfoItem = restDogChipService.getSaveInfoYoungItem();
			detail3.setTotalPrice(saveInfoItem.getPrice());
			detail3.setNum("1");
			detail3.setPrice(saveInfoItem.getPrice());
			detail3.setBusinessIds(dogChip.getId());
			detail3.setBusinessTable("dog_chip");
			detail3.setChargingItemId(saveInfoItem.getId());
			detail3.setChargingItemName(saveInfoItem.getName());
		} else {
			//两岁以上犬只无法办理
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该犬年龄已超过2岁，不允许办理新生犬登记");
		}

		paymentOrderDetailList.add(detail3);

		//收费项-血统证书
		PaymentChargingItem certificateItem = restDogChipService.getPedigreeCertifiedItem();
		PaymentOrderDetail detail4 = initOrderDetail(paymentOrder);
		detail4.setTotalPrice(certificateItem.getPrice());
		detail4.setNum("1");
		detail4.setPrice(certificateItem.getPrice());
		detail4.setBusinessIds(dogChip.getId());
		detail4.setBusinessTable("dog_chip");
		detail4.setChargingItemId(certificateItem.getId());
		detail4.setChargingItemName(certificateItem.getName());
		paymentOrderDetailList.add(detail4);

		//收费项-血样留存
		String dnaSaveWay = dogChip.getDnaSaveWay();
		if (StringUtils.isNotBlank(dnaSaveWay) && ("1".equals(dnaSaveWay) || "0".equals(dnaSaveWay))) {
			List<PaymentChargingItem> bloodSaveItem = restDogChipService.getBloodSaveItems(dogBirthCertificate, dogChip.getDnaSaveWay());
			for (PaymentChargingItem item : bloodSaveItem) {
				
				PaymentOrderDetail detailBloodSave = initOrderDetail(paymentOrder);
				DogBloodSave bloodSave = dogBloodSaveService.getByBirthCode(dogBirthCertificate.getBirthCerRegCode());
				detailBloodSave.setTotalPrice(item.getPrice());
				detailBloodSave.setNum("1");
				detailBloodSave.setPrice(item.getPrice());
				if(RestDogChipService.NOSE_LINE.equals(item.getShortName())) {
					detailBloodSave.setBusinessIds(dogChip.getId());
					detailBloodSave.setBusinessTable("dog_chip");
				}else {
					detailBloodSave.setBusinessIds(bloodSave.getId());
					detailBloodSave.setBusinessTable("dog_blood_save");
				}
				detailBloodSave.setChargingItemId(item.getId());
				detailBloodSave.setChargingItemName(item.getName());
				paymentOrderDetailList.add(detailBloodSave);
			}
		}

		//收费项-血样留存
		if (StringUtils.isNotBlank(dnaSaveWay) && "1".equals(dnaSaveWay)) {
			List<PaymentChargingItem> paymentChargingItems = dogDnaArchiveService.getDnaArchiveItem();
			DogDnaArchive dnaArchive = dogDnaArchiveService.getByBirthCode(dogBirthCertificate.getBirthCerRegCode());
			paymentChargingItems.stream().forEach(paymentChargingItem->{
				PaymentOrderDetail detail6 = initOrderDetail(paymentOrder);
				detail6.setTotalPrice(paymentChargingItem.getPrice());
				detail6.setNum("1");
				detail6.setPrice(paymentChargingItem.getPrice());
				detail6.setBusinessIds(dnaArchive.getId());
				detail6.setBusinessTable("dog_dna_archive");
				detail6.setChargingItemId(paymentChargingItem.getId());
				detail6.setChargingItemName(paymentChargingItem.getName());
				paymentOrderDetailList.add(detail6);
			});
			

			//收费项-血样留存
			if ("1".equals(dogChip.getIsDnaParentsCompare())) {
				DogDnaParentsCompare parent = dogDnaParentsCompareService.getByBirthCode(dogBirthCertificate.getBirthCerRegCode());
				//获取DNA双亲比对收费项
				PaymentChargingItem pci = restDogChipService.getDnaParentsCompareItem();
				PaymentOrderDetail detail7 = initOrderDetail(paymentOrder);
				detail7.setTotalPrice(pci.getPrice());
				detail7.setNum("1");
				detail7.setPrice(pci.getPrice());
				detail7.setBusinessIds(parent.getId());
				detail7.setBusinessTable("dog_dna_parents_compare");
				detail7.setChargingItemId(pci.getId());
				detail7.setChargingItemName(pci.getName());
				paymentOrderDetailList.add(detail7);
			}
		}

		//收费项-地方俱乐部芯片代打费
		if (!StringUtils.isBlank(dogChip.getChipInjectFlag()) && "1".equals(dogChip.getChipInjectFlag())) {
			PaymentChargingItem item = restDogChipService.getChipInjectItem();
			PaymentOrderDetail detail8 = initOrderDetail(paymentOrder);
			detail8.setTotalPrice(item.getPrice());
			detail8.setNum("1");
			detail8.setPrice(item.getPrice());
			detail8.setBusinessIds(dogChip.getId());
			detail8.setBusinessTable("dog_chip");
			detail8.setChargingItemId(item.getId());
			detail8.setChargingItemName(item.getName());
			paymentOrderDetailList.add(detail8);
		}

		if (StringUtils.isNotBlank(dnaSaveWay) && ("0".equals(dnaSaveWay) || "2".equals(dnaSaveWay))) {
			//收费项-鼻纹登记服务费
			PaymentChargingItem noseLineItem = restDogChipService.getNoseLineItem();
			PaymentOrderDetail detailNose = initOrderDetail(paymentOrder);
			detailNose.setTotalPrice(noseLineItem.getPrice());
			detailNose.setNum("1");
			detailNose.setPrice(noseLineItem.getPrice());
			detailNose.setBusinessIds(dogChip.getId());
			detailNose.setBusinessTable("dog_chip");
			detailNose.setChargingItemId(noseLineItem.getId());
			detailNose.setChargingItemName(noseLineItem.getName());
			paymentOrderDetailList.add(detailNose);
		}

		return paymentOrderDetailList;
	}

	/**
	 * @Description： 初始化订单详情
	 * @author: yuanshuai
	 * @date: 2020/7/30 13:28
	 * @param order
	 */
	private PaymentOrderDetail initOrderDetail(PaymentOrder order) {
		PaymentOrderDetail detail = new PaymentOrderDetail();
		detail.setAddTime(order.getAddTime());
		detail.setProccessState("0");
		detail.setMemberCode(order.getMemberCode());
		detail.setMemberName(order.getMemberName());
		return detail;
	}

	/**
	 * 计算月龄
	 * 
	 * @param date
	 * @param birthdate
	 * @return
	 */
	private int getMonthAge(Date date, Date birthdate) {
		Calendar dateCalendar = Calendar.getInstance();
		Calendar birthdateCalendar = Calendar.getInstance();
		dateCalendar.setTime(date);
		birthdateCalendar.setTime(birthdate);
		int monthAge = dateCalendar.get(Calendar.MONTH)
				- birthdateCalendar.get(Calendar.MONTH);
		if (dateCalendar.get(Calendar.YEAR) != birthdateCalendar
				.get(Calendar.YEAR)) {
			monthAge = (dateCalendar.get(Calendar.YEAR) - birthdateCalendar
					.get(Calendar.YEAR)) * 12 + monthAge;
		}
		birthdateCalendar.add(Calendar.MONTH, monthAge);
		if (birthdateCalendar.getTime().after(dateCalendar.getTime())) {
			monthAge = monthAge - 1;
		}
		return monthAge;
	}
}