package com.cku.oa.timedtask.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.context.support.SpringBeanAutowiringSupport;

import com.cku.oa.sys.dao.TaskLogDao;
import com.cku.oa.sys.entity.TaskLog;
import com.cku.util.SysConfig;
import com.thinkgem.jeesite.common.utils.SendMailUtil;

public class SendMail extends JobActingService{

	@Autowired
	private TaskLogDao taskLogDao;
	
	@Override
	@Transactional(readOnly = false)
	int doJob() {
		Map<String,Object> map = new HashMap<String,Object>();
		List<TaskLog> list =  taskLogDao.getLog();
		map.put("list", list==null?new ArrayList<>():list);
		String recipient = SysConfig.getInstance().getProperty("recipient");
		SendMailUtil.sendFtlMail(recipient, "计划任务执行日志", "mailtemplate/task.ftl", map);
		return 0;
	}

	@Override
	public int executeOnce() {
		SpringBeanAutowiringSupport.processInjectionBasedOnCurrentContext(this);
		Map<String,Object> map = new HashMap<String,Object>();
		List<TaskLog> list =  taskLogDao.getLog();
		map.put("list", list==null?new ArrayList<>():list);
		String recipient = SysConfig.getInstance().getProperty("recipient");
		SendMailUtil.sendFtlMail(recipient, "计划任务执行日志", "mailtemplate/task.ftl", map);
		return 0;
	}

	
}
