package com.cku.oa.timedtask.service;

import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.context.support.SpringBeanAutowiringSupport;

import com.cku.oa.show.entity.ChildShows;
import com.cku.oa.show.service.ChildShowsService;
import com.cku.oa.show.service.ShowResultsService;

@Service
@Transactional(readOnly = true)
public class OnceShowResultsTask extends JobActingService {

	private final Logger logger = LoggerFactory.getLogger(getClass());

	@Autowired
	private ShowResultsService showResultsService;

	@Autowired
	private ChildShowsService childShowsService;

	@SuppressWarnings("finally")
	int doJob() {
		int count = 0;
		try {
			// 重新统计2020年5月1日以后的子赛事积分
			List<ChildShows> list = childShowsService.find51List();
			for (ChildShows childShow : list) {
				showResultsService.countShowResult(childShow.getShowCode());
				count++;
			}
		} catch (Exception e) {
			logger.error("子赛事积分统计出错：", e);
		} finally {
			logger.error("修改数据,执行条数：" + count);
			return count;
		}
	}

	@Override
	@SuppressWarnings("finally")
	public int executeOnce() {
		int count = 0;
		try {
			SpringBeanAutowiringSupport.processInjectionBasedOnCurrentContext(this);
			// 重新统计2020年5月1日以后的子赛事积分
			List<ChildShows> list = childShowsService.find51List();
			for (ChildShows childShow : list) {
				showResultsService.countShowResult(childShow.getShowCode());
				count++;
			}
		} catch (Exception e) {
			logger.error("子赛事积分统计出错：", e);
		} finally {
			logger.error("修改数据,执行条数：" + count);
			return count;
		}
	}

}