package com.cku.oa.sys.web;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.cku.oa.sys.entity.ExpressQueue;
import com.cku.oa.sys.service.ExpressQueueCommonService;
import com.cku.oa.sys.service.ExpressQueueService;
import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;

/**
 * 待邮寄物品Controller
 * @author fanhuibin
 * @version 2016-09-01
 */
@Controller
@RequestMapping(value = "${adminPath}/sys/expressQueue")
public class ExpressQueueController extends BaseController {

	@Autowired
	private ExpressQueueService expressQueueService;
	@Autowired
	private ExpressQueueCommonService expressQueueCommonService;	
	
	@ModelAttribute
	public ExpressQueue get(@RequestParam(required=false) String id) {
		ExpressQueue entity = null;
		if (StringUtils.isNotBlank(id)){
			entity = expressQueueService.get(id);
		}
		if (entity == null){
			entity = new ExpressQueue();
		}
		return entity;
	}
	
	@RequiresPermissions("sys:expressQueue:view")
	@RequestMapping(value = {"list", ""})
	public String list(ExpressQueue expressQueue, HttpServletRequest request, HttpServletResponse response, Model model) {
		Page<ExpressQueue> page = expressQueueService.findPage(new Page<ExpressQueue>(request, response), expressQueue); 
		//model.addAttribute("province",UserUtils.getProvince());
		//model.addAttribute("city",UserUtils.getCityByProvince(expressQueue.getProvince()));
		model.addAttribute("page", page);
		return "oa/sys/expressQueueList";
	}
	
	@RequestMapping(value = {"search"})
	public String search(ExpressQueue expressQueue, HttpServletRequest request, HttpServletResponse response, Model model) {
		if(!StringUtils.isEmpty(expressQueue.getMemberCode())||!StringUtils.isEmpty(expressQueue.getMemberName())){
			List<ExpressQueue> list = expressQueueService.findList(expressQueue);
			list = expressQueueCommonService.filterList(list);
			
			Map<String,List<ExpressQueue>> result = new HashMap<String,List<ExpressQueue>>();
			
			for(ExpressQueue eQ :list){
				//判断一个收件地址是否重复，同时判断地址，人，电话信息
				String address = eQ.getProvince()+eQ.getCity()+eQ.getArea()+eQ.getStreet()+eQ.getReceiver()+eQ.getPhone();
				if( result.containsKey(address)){
					List<ExpressQueue> l = result.get(address);
					l.add(eQ);
				}else{
					List<ExpressQueue> l = new ArrayList<ExpressQueue>();
					l.add(eQ);
					result.put(address, l);
				}
			}
			model.addAttribute("result", result);
			model.addAttribute("count",result.size());
		}else{
			model.addAttribute("count",-1);
		}
		return "oa/sys/expressQueueSearch";
	}

	@RequiresPermissions("sys:expressQueue:view")
	@RequestMapping(value = "form")
	public String form(ExpressQueue expressQueue, Model model) {
		model.addAttribute("expressQueue", expressQueue);
		return "oa/sys/expressQueueForm";
	}

	@RequiresPermissions("sys:expressQueue:edit")
	@RequestMapping(value = "save")
	public String save(ExpressQueue expressQueue, Model model, RedirectAttributes redirectAttributes) {
		if (!beanValidator(model, expressQueue)){
			return form(expressQueue, model);
		}
		expressQueueService.save(expressQueue);
		addMessage(redirectAttributes, "保存待邮寄物品成功");
		return "redirect:"+Global.getAdminPath()+"/sys/expressQueue/?repage";
	}
	
	@RequiresPermissions("sys:expressQueue:delete")
	@RequestMapping(value = "delete")
	public String delete(ExpressQueue expressQueue, RedirectAttributes redirectAttributes) {
		expressQueueService.delete(expressQueue);
		addMessage(redirectAttributes, "删除待邮寄物品成功");
		return "redirect:"+Global.getAdminPath()+"/sys/expressQueue/?repage";
	}

}