/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.sys.entity;

import org.hibernate.validator.constraints.Length;

import com.thinkgem.jeesite.common.persistence.DataEntity;

/**
 * 会员手机号变更日志Entity
 * @author yuanshuai
 * @version 2018-02-11
 */
public class MemberMobileLog extends DataEntity<MemberMobileLog> {

	public static final String MOBILE_TYPE_BIND = "1";
	public static final String MOBILE_TYPE_CHANG = "2";

	private static final long serialVersionUID = 1L;
	private String memberCode;		// 会员号
	private String type;		// 类型（1为绑定、2为换绑）
	private String mobileOld;		// 原手机号
	private String mobileNew;		// 新手机号
	
	public MemberMobileLog() {
		super();
	}

	public MemberMobileLog(String id){
		super(id);
	}

	@Length(min=1, max=64, message="会员号长度必须介于 1 和 64 之间")
	public String getMemberCode() {
		return memberCode;
	}

	public void setMemberCode(String memberCode) {
		this.memberCode = memberCode;
	}
	
	@Length(min=1, max=1, message="类型（1为绑定、2为换绑）长度必须介于 1 和 1 之间")
	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}
	
	@Length(min=0, max=64, message="原手机号长度必须介于 0 和 64 之间")
	public String getMobileOld() {
		return mobileOld;
	}

	public void setMobileOld(String mobileOld) {
		this.mobileOld = mobileOld;
	}
	
	@Length(min=1, max=64, message="新手机号长度必须介于 1 和 64 之间")
	public String getMobileNew() {
		return mobileNew;
	}

	public void setMobileNew(String mobileNew) {
		this.mobileNew = mobileNew;
	}
	
}