/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.sys.entity;

import java.util.Date;

import javax.validation.constraints.NotNull;

import org.hibernate.validator.constraints.Length;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.thinkgem.jeesite.common.persistence.DataEntity;

/**
 * 邮寄发件Entity
 *
 * @author fanhuibin
 * @version 2016-09-01
 */
public class ExpressSend extends DataEntity<ExpressSend> {

	private static final long serialVersionUID = 1L;
	private String memberCode; // 会员号
	private String memberName; // 会员姓名
	private String content; // 发件内容/收件内容,(会员卡、血统证书等)
	private String contentValue;// 发件内容/收件内容,(特指采样包编号)
	private String reissueContentValue;// 发件内容/收件内容,(特指补寄采样包编号)
	private String expressType; // 类型，参考数据字典（express_type）
	private String expressName; // 快递名
	private String expressNo; // 快递单号
	private String address; // 会员地址
	private String postcode; // 会员的邮编
	private String receiver; // 收件人
	private Date receiveDate; // 收件日期
	private Date postDate; // 发件日期
	private String phone; // 电话
	private String sendRemarks; // 发件备注
	private String printState; // 打印状态

	private Date beginCreateDate; // 开始日期
	private Date endCreateDate;// 结束日期

	private String province; // 2019-08-31 改版
	private String city;
	private String sender; // 发件人 1:平阳中爱 2:宠爱王国
	private String sendAddress; // 发件地址
	private String sendPhone; // 发件人联系电话
	private String senderDetail; // 发件人详情
	private String otherExpressNo; //

	private String destcode; // 目的地区域代码
	private String origincode;// 原寄地区域代码,可用于顺丰电子面单标签打印。

	private String twoDimensionCode;// 二维码，面单打印使用
	private String proCode;// 失效类型，面单打印使用
	private String printIcon;
	private String destRouteLabel;
	private String codingMapping;
	private String destTeamCode;
	private String area;

	private String cloudPrintUrl;
	

	public String getArea() {
		return area;
	}

	public void setArea(String area) {
		this.area = area;
	}

	public String getDestRouteLabel() {
		return destRouteLabel;
	}

	public void setDestRouteLabel(String destRouteLabel) {
		this.destRouteLabel = destRouteLabel;
	}

	public String getCodingMapping() {
		return codingMapping;
	}

	public void setCodingMapping(String codingMapping) {
		this.codingMapping = codingMapping;
	}

	public String getDestTeamCode() {
		return destTeamCode;
	}

	public void setDestTeamCode(String destTeamCode) {
		this.destTeamCode = destTeamCode;
	}

	public String getPrintIcon() {
		return printIcon;
	}

	public void setPrintIcon(String printIcon) {
		this.printIcon = printIcon;
	}

	public String getProCode() {
		return proCode;
	}

	public void setProCode(String proCode) {
		this.proCode = proCode;
	}

	public String getTwoDimensionCode() {
		return twoDimensionCode;
	}

	public void setTwoDimensionCode(String twoDimensionCode) {
		this.twoDimensionCode = twoDimensionCode;
	}

	public String getDestcode() {
		return destcode;
	}

	public void setDestcode(String destcode) {
		this.destcode = destcode;
	}

	public String getOrigincode() {
		return origincode;
	}

	public void setOrigincode(String origincode) {
		this.origincode = origincode;
	}

	public Date getBeginCreateDate() {
		return beginCreateDate;
	}

	public void setBeginCreateDate(Date beginCreateDate) {
		this.beginCreateDate = beginCreateDate;
	}

	public Date getEndCreateDate() {
		return endCreateDate;
	}

	public void setEndCreateDate(Date endCreateDate) {
		this.endCreateDate = endCreateDate;
	}

	public ExpressSend() {
		super();
	}

	public ExpressSend(String id) {
		super(id);
	}

	@Length(min = 1, max = 60, message = "会员号长度必须介于 1 和 60 之间")
	public String getMemberCode() {
		return memberCode;
	}

	public void setMemberCode(String memberCode) {
		this.memberCode = memberCode;
	}

	@Length(min = 1, max = 100, message = "会员姓名长度必须介于 1 和 100 之间")
	public String getMemberName() {
		return memberName;
	}

	public void setMemberName(String memberName) {
		this.memberName = memberName;
	}

	public String getContent() {
		return content;
	}

	public void setContent(String content) {
		this.content = content;
	}

	@Length(min = 1, max = 100, message = "类型，参考数据字典（express_type）长度必须介于 1 和 100 之间")
	public String getExpressType() {
		return expressType;
	}

	public void setExpressType(String expressType) {
		this.expressType = expressType;
	}

	@Length(min = 1, max = 50, message = "快递名长度必须介于 1 和 50 之间")
	public String getExpressName() {
		return expressName;
	}

	public void setExpressName(String expressName) {
		this.expressName = expressName;
	}

	@Length(min = 0, max = 50, message = "快递单号长度必须介于 0 和 50 之间")
	public String getExpressNo() {
		return expressNo;
	}

	public void setExpressNo(String expressNo) {
		this.expressNo = expressNo;
	}

	@Length(min = 1, max = 255, message = "会员地址长度必须介于 1 和 255 之间")
	public String getAddress() {
		return address;
	}

	public void setAddress(String address) {
		this.address = address;
	}

	@Length(min = 0, max = 20, message = "会员的邮编长度必须介于 0 和 20 之间")
	public String getPostcode() {
		return postcode;
	}

	public void setPostcode(String postcode) {
		this.postcode = postcode;
	}

	@Length(min = 0, max = 100, message = "收件人长度必须介于 0 和 100 之间")
	public String getReceiver() {
		return receiver;
	}

	public void setReceiver(String receiver) {
		this.receiver = receiver;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getReceiveDate() {
		return receiveDate;
	}

	public void setReceiveDate(Date receiveDate) {
		this.receiveDate = receiveDate;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	@NotNull(message = "发件日期不能为空")
	public Date getPostDate() {
		return postDate;
	}

	public void setPostDate(Date postDate) {
		this.postDate = postDate;
	}

	@Length(min = 0, max = 64, message = "电话长度必须介于 0 和 64 之间")
	public String getPhone() {
		return phone;
	}

	public void setPhone(String phone) {
		this.phone = phone;
	}

	public String getSendRemarks() {
		return sendRemarks;
	}

	public void setSendRemarks(String sendRemarks) {
		this.sendRemarks = sendRemarks;
	}

	public String getPrintState() {
		return printState;
	}

	public void setPrintState(String printState) {
		this.printState = printState;
	}

	public String getProvince() {
		return province;
	}

	public void setProvince(String province) {
		this.province = province;
	}

	public String getCity() {
		return city;
	}

	public void setCity(String city) {
		this.city = city;
	}

	public String getSender() {
		return sender;
	}

	public void setSender(String sender) {
		this.sender = sender;
	}

	public String getSendAddress() {
		return sendAddress;
	}

	public void setSendAddress(String sendAddress) {
		this.sendAddress = sendAddress;
	}

	public String getSendPhone() {
		return sendPhone;
	}

	public void setSendPhone(String sendPhone) {
		this.sendPhone = sendPhone;
	}

	public String getSenderDetail() {
		return senderDetail;
	}

	public void setSenderDetail(String senderDetail) {
		this.senderDetail = senderDetail;
	}

	public String getOtherExpressNo() {
		return otherExpressNo;
	}

	public void setOtherExpressNo(String otherExpressNo) {
		this.otherExpressNo = otherExpressNo;
	}

	public String getCloudPrintUrl() {
		return cloudPrintUrl;
	}

	public void setCloudPrintUrl(String cloudPrintUrl) {
		this.cloudPrintUrl = cloudPrintUrl;
	}

	public String getContentValue() {
		return contentValue;
	}

	public void setContentValue(String contentValue) {
		this.contentValue = contentValue;
	}

	public String getReissueContentValue() {
		return reissueContentValue;
	}

	public void setReissueContentValue(String reissueContentValue) {
		this.reissueContentValue = reissueContentValue;
	}

}