/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.sys.entity;

import org.hibernate.validator.constraints.Length;

import com.thinkgem.jeesite.common.persistence.DataEntity;

/**
 * 鉴定师表Entity
 * @author zhangjunwu
 * @version 2019-10-16
 */
public class Appraiser extends DataEntity<Appraiser> {
	
	private static final long serialVersionUID = 1L;
	private String name;		// 认证师姓名
	private String nameEn;		// 认证师姓名拼音
	private String photo;		// 认证师照片
	private String level;		// 认证师级别
	private String certificateNum;		// 证书编号
	private String mobile;		// 联系电话
	private String province;		// 联系地址省
	private String city;		// 联系地址市
	private String street;		// 联系地址详情
	private String orgId;		// 合作机构ID
	private String orgCode;		// 合作机构编号
	private String reviewState;		// 审核状态
	private String printFlag;//打印标识
	
	public Appraiser() {
		super();
	}

	public Appraiser(String id){
		super(id);
	}

	@Length(min=0, max=64, message="认证师姓名长度必须介于 0 和 64 之间")
	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}
	
	@Length(min=0, max=64, message="认证师姓名拼音长度必须介于 0 和 64 之间")
	public String getNameEn() {
		return nameEn;
	}

	public void setNameEn(String nameEn) {
		this.nameEn = nameEn;
	}
	
	@Length(min=0, max=256, message="认证师照片长度必须介于 0 和 256 之间")
	public String getPhoto() {
		return photo;
	}

	public void setPhoto(String photo) {
		this.photo = photo;
	}
	
	@Length(min=0, max=1, message="认证师级别长度必须介于 0 和 1 之间")
	public String getLevel() {
		return level;
	}

	public void setLevel(String level) {
		this.level = level;
	}
	
	@Length(min=0, max=64, message="证书编号长度必须介于 0 和 64 之间")
	public String getCertificateNum() {
		return certificateNum;
	}

	public void setCertificateNum(String certificateNum) {
		this.certificateNum = certificateNum;
	}
	
	@Length(min=0, max=20, message="联系电话长度必须介于 0 和 20 之间")
	public String getMobile() {
		return mobile;
	}

	public void setMobile(String mobile) {
		this.mobile = mobile;
	}
	
	@Length(min=0, max=64, message="联系地址省长度必须介于 0 和 64 之间")
	public String getProvince() {
		return province;
	}

	public void setProvince(String province) {
		this.province = province;
	}
	
	@Length(min=0, max=64, message="联系地址市长度必须介于 0 和 64 之间")
	public String getCity() {
		return city;
	}

	public void setCity(String city) {
		this.city = city;
	}
	
	@Length(min=0, max=500, message="联系地址详情长度必须介于 0 和 500 之间")
	public String getStreet() {
		return street;
	}

	public void setStreet(String street) {
		this.street = street;
	}
	
	@Length(min=0, max=64, message="合作机构ID长度必须介于 0 和 64 之间")
	public String getOrgId() {
		return orgId;
	}

	public void setOrgId(String orgId) {
		this.orgId = orgId;
	}
	
	@Length(min=0, max=64, message="合作机构编号长度必须介于 0 和 64 之间")
	public String getOrgCode() {
		return orgCode;
	}

	public void setOrgCode(String orgCode) {
		this.orgCode = orgCode;
	}
	
	@Length(min=0, max=20, message="审核状态长度必须介于 0 和 20 之间")
	public String getReviewState() {
		return reviewState;
	}

	public void setReviewState(String reviewState) {
		this.reviewState = reviewState;
	}

	public String getPrintFlag() {
		return printFlag;
	}

	public void setPrintFlag(String printFlag) {
		this.printFlag = printFlag;
	}
	
}